unit PtrSrch;

interface

uses
  SysUtils, Classes, CommonUnit;

Type
  DWord = LongWord;
  TByteArray = Array[0..3] of Byte;
  TStopData = Array of Byte;
  TPtrData = Packed Record
    pReference:   DWord;
    pSize:        Byte;
    pMotorola:    Boolean;
    pInterval:    Integer;
    pStep:        Integer;
  end;
  TSearchData = Packed Record
    sTOffset:     Int64;
    sTP:          Pointer;
    sTSize:       Integer;
    sPOffset:     Int64;
    sPP:          Pointer;
    sPSize:       Int64;
    sMultiply:    Integer;
    sInterval:    Integer;
    sStopData:    TStopData;
    sPtrData:     TPtrData;
  end;
  TProgressProc = Procedure(I: Integer);

var
  psStopSearch: Boolean = False;

Function ToMot(X: Integer; SZ: Byte): Integer;                              
Function GetPtr(V: Dword; PtrData: TPtrData): DWord;
Function CutVal(V,Sz: Integer): Integer;
Function FindPtr(SearchValue: DWord; P: Pointer; Size: Int64; PtrData: TPtrData): DWord;
Function ExtractPtrs(var List: TStringList; Data: TSearchData; nfString: String = '';
Proc: TProgressProc = NIL): Integer;
implementation


Function ToMot(X: Integer; SZ: Byte): Integer;
var B,B1: TByteArray; n: Integer;
begin
  B:=TByteArray(X);
  For n:=0 To Sz-1 do B1[n]:=B[Sz-n-1];
  Result:=Integer(B1);
end;

Function CutVal(V,Sz: Integer): Integer;
begin
  Result:=0;
  FillChar(Result,Sz,$FF);
  Result:=V AND Result;
end;

Function GetPtr(V: Dword; PtrData: TPtrData): DWord;
begin
  With PtrData do
  begin
    Result := V - pReference;
    Result:=CutVal(Result, pSize);
    If pMotorola Then Result:=ToMot(Result,pSize);
  end;
end;


Function ExtractPtrs(var List: TStringList; Data: TSearchData; nfString: String = '';
Proc: TProgressProc = NIL): Integer;
var B: ^Byte; Position,FPos,sdLength: Integer;
begin
  With Data do
  begin
    sdLength:=Length(sStopData);
    If sPtrData.pStep<=0 Then sPtrData.pStep:=sPtrData.pSize;
    B:=sTP;
    While DWord(B)-DWord(sTP)<=sTSize do
    begin
      If psStopSearch Then Exit;
      FPos:=0;
      Position:=0;
      If @Proc<>NIL Then Proc(DWord(B)-DWord(sTP));
      While FPos<>-1 do
      begin
        Inc(Position,FPos);
        FPos:=FindPtr(sTOffset+(DWord(B)-DWord(sTP)),Pointer(DWord(sPP)+Position),sPSize-Position,sPtrData);
        If FPos<>-1 Then List.Add(Format('%.8x',[FPos+sPOffset+Position])) else
        If nfString<>'' Then List.Add(nfString);
        If FPos=-1 Then Break;
        With sPtrData do
        begin
          Inc(FPos,pInterval+pStep);
          If FPos+pSize>sPSize Then FPos:=-1;
        end;
      end;
      Inc(B);
      While (DWord(B)-DWord(sTP)<=sTSize) and not CompareMem(B,Addr(sStopData[0]),sdLength) do Inc(B);
      Inc(B,sdLength); B:=Pointer(DWord(sTP)+RoundBy(DWord(B)-DWord(sTP),sMultiply));
      Inc(B,sInterval);
    end;
  end;
end;


Function FindPtr(SearchValue: DWord; P: Pointer; Size: Int64; PtrData: TPtrData): DWord;
var Pos: DWord; DW: ^DWord; Ptr: DWord; PPtr: Pointer; I: DWord;
begin
  With PtrData do
  begin
    I:=0;
    FillChar(I,pSize,$FF);
    If pStep=0 Then pStep:=pSize;
    Ptr:=GetPtr(SearchValue,PtrData);
    PPtr:=Addr(Ptr);
    DW:=P;
    While DWord(DW)-DWord(P)+pStep+pInterval<=Size do
    begin
      //If CutVal(DW^,pSize)=Ptr Then
      //If CompareMem(DW,PPtr,pSize) Then
      If Ptr=DW^ AND I Then
      begin
        Result:=DWord(DW)-DWord(P);
        Exit;
      end;
      Inc(DWord(DW),pStep{+pInterval});
    end;
    Result:=$FFFFFFFF;
  end;
end;

end.
