unit PSearch;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, XPMan, Menus, ActnList, StdCtrls, Grids, ValEdit, PtrSrch,
  ComCtrls, ToolWin, ImgList, CommonUnit;

type
  TForm1 = class(TForm)
    XPManifest1: TXPManifest;
    ValList: TValueListEditor;
    PtrList: TMemo;
    ActionList: TActionList;
    MainMenu1: TMainMenu;
    ValueMenu: TPopupMenu;
    ListMenu: TPopupMenu;
    Savetofile1: TMenuItem;
    Clear1: TMenuItem;
    AListClear: TAction;
    ODlg: TOpenDialog;
    SDlg: TSaveDialog;
    AListSave: TAction;
    File1: TMenuItem;
    Select1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    AExit: TAction;
    ASelectFile: TAction;
    StatusBar: TStatusBar;
    ProgressBar: TProgressBar;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ARun: TAction;
    ImageList: TImageList;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    AAbout: TAction;
    Search1: TMenuItem;
    AStop: TAction;
    Runsearch1: TMenuItem;
    Stop1: TMenuItem;
    N2: TMenuItem;
    AListSave1: TMenuItem;
    AListClear1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Selectfile1: TMenuItem;
    AMotorola: TAction;
    AMotorola1: TMenuItem;
    N3: TMenuItem;
    Motorola1: TMenuItem;
    Edit1: TMenuItem;
    Saveconfiguration1: TMenuItem;
    ALoadConfig: TAction;
    ASaveConfig: TAction;
    Saveconfiguration2: TMenuItem;
    LoadConfigDialog: TOpenDialog;
    SaveConfigDialog: TSaveDialog;
    procedure AListClearExecute(Sender: TObject);
    procedure AListSaveExecute(Sender: TObject);
    procedure AExitExecute(Sender: TObject);
    procedure AMotorolaExecute(Sender: TObject);
    procedure ASelectFileExecute(Sender: TObject);
    procedure AStopExecute(Sender: TObject);
    procedure ARunExecute(Sender: TObject);
    procedure AAboutExecute(Sender: TObject);
    procedure ASaveConfigExecute(Sender: TObject);
    procedure ALoadConfigExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ValListValidate(Sender: TObject; ACol, ARow: Integer;
      const KeyName, KeyValue: String);
    procedure ValListEditButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    procedure SetStrings;
    procedure SetData;
    function CheckData: Boolean;
    { Public declarations }
  end;

var
  Form1: TForm1;
  Data:  TSearchData;
  List:  TStringList;

implementation

{$R *.dfm}

const
  cFile = 'File';
  cTextBlockPos  = 'TextBlockOffset';
  cTextBlockSize = 'TextBlockSize';
  cTextMultiply  = 'TextMultiply';
  cStopData      = 'StopData';
  cPtrBlockPos   = 'PtrBlockOffset';
  cPtrBlockSize  = 'PtrBlockSize';
  cPtrSize       = 'PtrSize';
  cPtrReference  = 'PtrReference';
  cPtrStep       = 'PtrStep';
  cPtrInterval   = 'PtrInterval';
  cMotorola      = 'Motorola';


Procedure TForm1.SetData;
var Code,n: Integer; S: String;
begin
  With ValList, Data, Data.sPtrData do
  begin
    Val(Values[cTextBlockPos],  sTOffset,   Code);
    Val(Values[cTextBlockSize], sTSize,     Code);
    Val(Values[cTextMultiply],  sMultiply,  Code);
    Val(Values[cPtrSize],       pSize,      Code);
    Val(Values[cPtrReference],  pReference, Code);
    Val(Values[cPtrStep],       pStep,      Code);
    Val(Values[cPtrInterval],   pInterval,  Code);
    Val(Values[cPtrBlockPos],   sPOffset,   Code);
    Val(Values[cPtrBlockSize],  sPSize,     Code);
    S:=Values[cStopData];
    SetLength(sStopData,Length(S) div 2);
    For n:=1 To Length(sStopData) do
      sStopData[n-1]:=HexToInt(Format('%s%s',[S[n*2-1],S[n*2]]));
      
    pMotorola := LowerCase(Values[cMotorola])='true';
  end;
end;

function TForm1.CheckData: Boolean;
begin
  
end;

Procedure ShowProgress(I: Integer);
begin
  With Form1 do
  begin
    ProgressBar.Position:=I;
    StatusBar.Panels[0].Text:=Format('[%d%%] %.8x/%.8x - %d ptrs',[Round((I/Data.sTSize)*100),I,Data.sTSize,List.Count]);
    PtrList.Text:=List.Text;
    Application.ProcessMessages;
  end;
end;

procedure ShowError(S: String; Caption: String = 'ERROR');
begin
  MessageBox(Form1.Handle,PChar(S),PChar(Caption),MB_OK or MB_ICONEXCLAMATION);
end;

procedure TForm1.AListClearExecute(Sender: TObject);
begin
  PtrList.Clear;
end;

procedure TForm1.AListSaveExecute(Sender: TObject);
begin
  If not SDlg.Execute Then Exit;
  Try
    PtrList.Lines.SaveToFile(SDlg.FileName);
  except
    MessageBox(Self.Handle,PChar('Error saving file!'),'ERROR',MB_OK);
  end;
end;

procedure TForm1.AExitExecute(Sender: TObject);
begin
  Close;
end;

procedure TForm1.AMotorolaExecute(Sender: TObject);
begin
  AMotorola.Checked:=not AMotorola.Checked;
  If AMotorola.Checked Then
    ValList.Values[cMotorola]:='True'
  else
    ValList.Values[cMotorola]:='False';
end;

procedure TForm1.ASelectFileExecute(Sender: TObject);
begin
  If not ODlg.Execute Then Exit;
  If FileExists(ODlg.FileName) Then
    ValList.Values[cFile]:=ODlg.FileName
  else
    ShowError('File not exists!');
end;

procedure TForm1.AStopExecute(Sender: TObject);
begin
  psStopSearch:=True;
end;

procedure TForm1.ARunExecute(Sender: TObject);
var TBuf,PBuf: Pointer; F: File;
begin
  With ValList, Data do
  begin
    If not CheckData Then Exit;
    StatusBar.Panels[1].Text:='Loading...';
    Application.ProcessMessages;
    List.Clear;
    psStopSearch:=False;
    SetData;
    Try
      AssignFile(F,Values[cFile]);
      Reset(F,1);
    except
      ShowError('Cannot open file!');
      Exit;
    end;
    If sTSize=0 Then sTSize:=FileSize(F)-sTOffset;
    If sPSize=0 Then sPSize:=FileSize(F)-sPOffset;

    Seek(F,sTOffset);
    GetMem(TBuf,sTSize);
    BlockRead(F,TBuf^,sTSize);

    Seek(F,sPOffset);
    GetMem(PBuf,sPSize);
    BlockRead(F,PBuf^,sPSize);

    AStop.Enabled:=True;
    ARun.Enabled:=False;

    sTP:=TBuf;
    sPP:=PBuf;
    ProgressBar.Min:=0;
    ProgressBar.Max:=sTSize;
    StatusBar.Panels[2].Text:=ExtractFileName(Values[cFile]);

    StatusBar.Panels[1].Text:='Searching...';
    Application.ProcessMessages;
    ExtractPtrs(List,Data,'',ShowProgress);

    AStop.Enabled:=False;
    ARun.Enabled:=True;

    FreeMem(TBuf);
    FreeMem(PBuf);
    If psStopSearch Then
      StatusBar.Panels[1].Text:='Stopped.'
    else
      StatusBar.Panels[1].Text:='Done!';
    Application.ProcessMessages;
  end;
end;

procedure TForm1.AAboutExecute(Sender: TObject);
var S: String;
begin
  S:='Pointer Searcher by HoRRoR <horror.cg@gmail.com> <ho-rr-or@mail.ru>'#13#10'http://consolgames.ru/';
  MessageBox(Form1.Handle,PChar(S),'About...', MB_OK or MB_ICONQUESTION);
end;

procedure TForm1.ASaveConfigExecute(Sender: TObject);
begin
  If SaveConfigDialog.Execute Then
    ValList.Strings.SaveToFile(ChangeFileExt(SaveConfigDialog.FileName, '.cfg'));
end;

procedure TForm1.ALoadConfigExecute(Sender: TObject);
begin
  If LoadConfigDialog.Execute Then
    ValList.Strings.LoadFromFile(SaveConfigDialog.FileName);
  SetStrings;
end;

procedure TForm1.SetStrings;
var n: Integer;
begin
  With ValList do
  begin
    Keys[1]  := cFile;
    Keys[2]  := cTextBlockPos;
    Keys[3]  := cTextBlockSize;
    Keys[4]  := cTextMultiply;
    Keys[5]  := cStopData;
    Keys[6]  := cPtrBlockPos;
    Keys[7]  := cPtrBlockSize;
    Keys[8]  := cPtrSize;
    Keys[9]  := cPtrReference;
    Keys[10]  := cPtrStep;
    Keys[11]  := cPtrInterval;
    Keys[12] := cMotorola;
    
    ItemProps[cMotorola].PickList.Add('False');
    ItemProps[cMotorola].PickList.Add('True');
    ItemProps[cMotorola].EditStyle := esPickList;
    //ItemProps[cFile].
    ItemProps[cFile].EditStyle := esEllipsis;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  SetStrings;
end;

procedure TForm1.ValListValidate(Sender: TObject; ACol, ARow: Integer;
  const KeyName, KeyValue: String);
begin
  If KeyName = cMotorola Then
  begin
    If (LowerCase(ValList.Values[cMotorola]) <> 'false') and
       (LowerCase(ValList.Values[cMotorola]) <> 'true') Then
          ValList.Values[cMotorola] := 'False';
    If LowerCase(ValList.Values[cMotorola]) = 'true' Then
      AMotorola.Checked := True
    else
      AMotorola.Checked := False;
  end;
end;

procedure TForm1.ValListEditButtonClick(Sender: TObject);
begin
  ASelectFileExecute(nil);
end;

Initialization
  List:=TStringList.Create;
Finalization
  List.Free;
end.
