program ttcomp;

{$APPTYPE CONSOLE}

uses
  KOL;

const
  srchBufSize = $40;
  bufferSize = $400;

type
  TByteArray = array[0..$7FFF] of Byte;
  PByteArray = ^TByteArray;

type
  TSearchResult = record
    offset: Word;
    matched: byte;
  end;

function Swap16(Value: word): word; register;
asm
  xchg  al, ah
end;

function Search_in_Buffer(searchBuf, lookupBuf: PByteArray; var BufPos: word;
  Size: byte): TSearchResult;
var
  loop, k, i, j: Word;
  BufPosRestore, BufPosMax: Word;
  restorebuf: PByteArray;
begin
  loop := 0;
  Result.offset := BufPos;
  result.matched := 0;

  while loop < bufferSize - 1 do
  begin

    j := 0;
    i := loop;
    while (j < bufferSize) and (searchBuf^[0] <> lookupBuf^[i]) do
    begin
      i := (i + 1) and $3FF;
      Inc(j);
    end;

    if j = bufferSize then
      Break;

    k := 0;
    BufPosRestore := BufPos;
    restorebuf := GetMemory(srchBufSize);
    FillChar(restorebuf^[0], srchBufSize, 0);
    BufPosMax := i;

    while (k < size) and (searchBuf^[k] = lookupBuf^[i]) do
    begin
      restorebuf^[k] := lookupBuf^[BufPos];
      lookupBuf^[BufPos] := searchBuf^[k];
      BufPos := (BufPos + 1) and $3FF;
      i := (i + 1) and $3FF;
      Inc(k);
    end;

    BufPos := BufPosRestore;

    for j := 1 to k do
    begin
      lookupBuf^[BufPosRestore] := restorebuf^[j];
      BufPosRestore := (BufPosRestore + 1) and $3FF;
    end;

    FreeMemory(restorebuf);

    if result.matched < k then
    begin
      result.matched := k;
      result.offset := BufPosMax;
    end;
    inc(loop);
  end;

  case result.matched of
    0: Inc(result.matched);
    2: dec(result.matched);
  end;

  for i := 0 to result.matched - 1 do
  begin
    lookupBuf^[BufPos] := searchBuf^[i];
    BufPos := (BufPos + 1) and $3FF;
  end;
end;

function TT_Compress(const inStr: string): cardinal;
var
  comp, decomp, tmp: PStream;
  retnPos, buffPos, copySize: word;
  buffer: PByteArray;
  i, count, z: Integer;
  bufw: word;
  cmpSize: Word;
  readen: byte;
  srchBuf: PByteArray;
  matched, BitsCnt, cmdByte: byte;
  cmdBytePos, currPos: Cardinal;
  SrchRes: TSearchResult;
  outStr: string;
begin
  count := FileSize(inStr) mod $800 + 1;
  result := 0;

  tmp := NewReadFileStream(inStr);

  for z := 1 to count do
  begin
    decomp := NewMemoryStream;
    comp := NewMemoryStream;

    Stream2Stream(decomp, tmp, $800);
    decomp.Seek(0, spBegin);

    comp.WriteVal(0, 2);

    cmdBytePos := comp.Position;
    comp.WriteVal(0, 1);

    buffer := GetMemory(bufferSize);

    for i := 1 to bufferSize do
      buffer^[i] := $20;

    buffPos := $3C0;
    cmdByte := 0;
    bitscnt := 0;

    while True do
    begin
      srchBuf := GetMemory(srchBufSize);
      FillChar(srchBuf^[0], srchBufSize, 0);
      readen := decomp.Read(srchBuf^[0], srchBufSize);

      SrchRes := Search_in_Buffer(srchBuf, buffer, buffPos, readen);
      matched := SrchRes.matched;
      retnPos := SrchRes.offset;
      decomp.Seek(-readen + matched, spCurrent);

      case matched of
        1:
          begin
            cmdByte := (1 shl BitsCnt) + cmdByte;
            inc(BitsCnt);

            comp.Write(srchBuf^[0], 1);
          end;
        3..srchBufSize:
          begin
            cmdByte := (0 shl BitsCnt) + cmdByte;
            inc(BitsCnt);

            copySize := (matched - 1) shl 10;
            bufw := swap16(copySize + retnPos);
            comp.Write(bufw, 2);
          end;
      end;

      if (bitscnt = 8) or (readen < srchBufSize) then
      begin
        bitscnt := 0;
        currPos := comp.Position;
        comp.Seek(cmdBytePos, spBegin);
        comp.Write(cmdByte, 1);
        //comp.Seek(currPos + 1, spBegin);
        cmdBytePos := currPos;
        cmdByte := 0;

        if (readen < srchBufSize) then
          Break
        else
          comp.Seek(currPos + 1, spBegin);
      end;

      FreeMemory(srchBuf);
    end;

    comp.Seek(0, spBegin);
    cmpSize := (comp.Size - 2) and $FFFF;
    bufw := swap16(cmpSize);
    comp.Write(bufw, 2);
    outStr := ExtractFilePath(inStr) + ExtractFileNameWOext(inStr) + '.' +
      Int2Digs(z, 2) + '.cmp.bin';
    comp.SaveToFile(outStr, 0, comp.Size);

    Free_And_Nil(decomp);
    FreeMemory(buffer);
    Free_And_Nil(comp);

    Result := ((cmpSize + 2) shl 16) + FileSize(inStr);

    Writeln('Compressed file was save as: "' + ExtractFileName(outStr) + '";');
    Writeln('Decompressed size: ' + int2str(Result and $FFFF) + ' bytes;');
    Writeln('Compressed size: ' + int2str(Result and $FFFF0000 shr 16) +
      ' bytes.');
  end;

  Free_And_Nil(tmp);
end;

function TT_Decompress(const inStr: string; offset: cardinal): cardinal;
var
  comp, decomp: PStream;
  retnPos, buffPos, copySize: word;
  buffer: PByteArray;
  i: Integer;
  bufw: word;
  cmpSize, rdnSize: Word;
  bit, bufb: byte;
  bitscnt, cmdByte: byte;
  outStr: string;
begin
  comp := NewReadFileStream(inStr);
  comp.Seek(offset, spBegin);
  decomp := NewMemoryStream;

  buffer := GetMemory(bufferSize);

  for i := 0 to bufferSize - 1 do
    buffer^[i] := $20;

  buffPos := $3C0;
  cmdByte := 0;

  comp.Read(bufw, 2);
  cmpSize := Swap16(bufw);

  rdnSize := 0;
  bitscnt := 0;

  while rdnSize < cmpSize do
  begin
    if bitscnt = 0 then
    begin
      comp.Read(cmdByte, 1);
      Inc(rdnSize);
      bitscnt := 8;
    end;

    bit := GetBitsL(cmdByte, 0, 1);
    cmdByte := cmdByte shr 1;
    Dec(bitscnt);

    if bit = 1 then
    begin
      comp.Read(bufb, 1);
      Inc(rdnSize);
      decomp.Write(bufb, 1);
      buffer^[buffPos] := bufb;
      buffPos := (buffPos + 1) and $3FF;
    end
    else
    begin
      comp.Read(bufw, 2);
      bufw := Swap16(bufw);
      copySize := (bufw and $FC00) shr 10 + 1;
      retnPos := bufw and $3FF;
      Inc(rdnSize, 2);

      for i := 0 to copySize - 1 do
      begin
        decomp.Write(buffer^[(retnPos + i) and $3FF], 1);
        buffer^[buffPos] := buffer^[(retnPos + i) and $3FF];
        buffPos := (buffPos + 1) and $3FF;
      end;
    end;
  end;

  outStr := ExtractFilePath(inStr) + ExtractFileNameWOext(inStr) +
    '_' + Int2Hex(offset, 4) + '.bin';
  decomp.SaveToFile(outStr, 0, decomp.Size);
  Result := (comp.Position - offset) shl 16 + (decomp.Size);
  Free_And_Nil(comp);
  Free_And_Nil(Decomp);
  FreeMemory(buffer);

  Writeln('Decompressed file was save as: "' + ExtractFileName(outStr) + '";');
  Writeln('Compressed size: ' + int2str(Result and $FFFF0000 shr 16) + ' bytes '
    +
    '(this size was copied to clipboard);');
  Writeln('Decompressed size: ' + int2str(Result and $FFFF) + ' bytes.');
end;

procedure Help;
begin
  Writeln('-= TTA - BHT Compression Tool v1.0 [by Lab 313] (06.01.2013) =-');
  Writeln('-----------------------------');
  Writeln('Compression type: LZ77-Like');
  Writeln('Decompressor | Compressor: Dr. MefistO');
  Writeln('Coding: Dr. MefistO');
  Writeln('Our site: http://lab313.ru');
  Writeln('Info: This console tool allows you to compress and decompress' +
    #13#10 + '      all of graphics archives in the ' + #13#10 +
    '      "Tiny Toon Adventures - Buster''s Hidden Treasure" game.' + #13#10);
  Writeln('USAGE FOR DECOMPRESSION:' + #13#10 +
    'ttcomp.exe [Filename] [HexOffset]' + #13#10 +
    'EXAMPLE:' + #13#10 +
    'ttcomp.exe TT.bin 34A2A' + #13#10);
  Writeln('USAGE FOR COMPRESSION:' + #13#10 +
    'ttcomp.exe [InFilename]' + #13#10 +
    'EXAMPLE:' + #13#10 +
    'ttcomp.exe 1E152.bin' + #13#10 +
    '-----------------------------' + #13#10);
end;

var
  offset: Cardinal;

begin
  Help;
  if not FileExists(ParamStr(1)) then
  begin
    Writeln('File not found: "' + ExtractFileName(ParamStr(1)) + '"' + #13#10);
    Exit;
  end;
  offset := cHex2Int(ParamStr(2));
  if FileSize(ParamStr(1)) <= offset then
  begin
    Writeln('Specified offset is greater than size of packed data!' + #13#10);
    Exit;
  end;

  if ParamCount = 2 then
  begin
    Writeln('Decompressing "' + ExtractFileName(ParamStr(1)) + '" from 0x' +
      int2Hex(offset, 4) + '...');
    TT_Decompress(ParamStr(1), offset);
    Exit;
  end
  else if ParamCount = 1 then
  begin
    Writeln('Compressing "' + ExtractFileName(ParamStr(1)) + '"...');
    TT_Compress(ParamStr(1));
    Exit;
  end
  else
    Help;
  //Text2Clipboard(Int2Str(size));
end.

