unit uCompression;

interface

uses
  KOL, Windows, err;

type
  PDWORD = ^cardinal;

type
  TNibble = (nbLeft, nbRight);  

  procedure EncodeLZH(infile, outfile: PStream; Size: cardinal);
  procedure DecodeLZH(infile, outfile: PStream; size: cardinal);
  procedure EncodeRLE(uncprStream, cprStream: PStream; Size: cardinal);
  procedure DecodeRLE(cprStream, uncprStream: PStream; offset: cardinal);
  function Ceil(X: Extended): Integer;
  function Swap32(Value: cardinal): cardinal; register;
  function Swap16(Value: word): word; register;
  function GetNibble(b: Byte; Nb: TNibble): Byte;

implementation

const
  N = 4096;
  F = 60;
  THRESHOLD = 2;
  NUL = N;
  N_CHAR = ($100 - THRESHOLD + F);
  T = (N_CHAR * 2 - 1);
  ROOT = T - 1;
  MAX_FREQ = $8000;

{ encoder table }
  p_len : array[0..$3F] of byte = (
  $03, $04, $04, $04, $05, $05, $05, $05,
	$05, $05, $05, $05, $06, $06, $06, $06,
	$06, $06, $06, $06, $06, $06, $06, $06,
	$07, $07, $07, $07, $07, $07, $07, $07,
	$07, $07, $07, $07, $07, $07, $07, $07,
	$07, $07, $07, $07, $07, $07, $07, $07,
	$08, $08, $08, $08, $08, $08, $08, $08,
	$08, $08, $08, $08, $08, $08, $08, $08);

  p_code : array [0..$3F] of byte = (
  $00, $20, $30, $40, $50, $58, $60, $68,
	$70, $78, $80, $88, $90, $94, $98, $9C,
	$A0, $A4, $A8, $AC, $B0, $B4, $B8, $BC,
	$C0, $C2, $C4, $C6, $C8, $CA, $CC, $CE,
	$D0, $D2, $D4, $D6, $D8, $DA, $DC, $DE,
	$E0, $E2, $E4, $E6, $E8, $EA, $EC, $EE,
	$F0, $F1, $F2, $F3, $F4, $F5, $F6, $F7,
	$F8, $F9, $FA, $FB, $FC, $FD, $FE, $FF);

{ decoder table }
  d_code: array [0..$FF] of byte = (
  $00, $00, $00, $00, $00, $00, $00, $00,
	$00, $00, $00, $00, $00, $00, $00, $00,
	$00, $00, $00, $00, $00, $00, $00, $00,
	$00, $00, $00, $00, $00, $00, $00, $00,
	$01, $01, $01, $01, $01, $01, $01, $01,
	$01, $01, $01, $01, $01, $01, $01, $01,
	$02, $02, $02, $02, $02, $02, $02, $02,
	$02, $02, $02, $02, $02, $02, $02, $02,
	$03, $03, $03, $03, $03, $03, $03, $03,
	$03, $03, $03, $03, $03, $03, $03, $03,
	$04, $04, $04, $04, $04, $04, $04, $04,
	$05, $05, $05, $05, $05, $05, $05, $05,
	$06, $06, $06, $06, $06, $06, $06, $06,
	$07, $07, $07, $07, $07, $07, $07, $07,
	$08, $08, $08, $08, $08, $08, $08, $08,
	$09, $09, $09, $09, $09, $09, $09, $09,
	$0A, $0A, $0A, $0A, $0A, $0A, $0A, $0A,
	$0B, $0B, $0B, $0B, $0B, $0B, $0B, $0B,
	$0C, $0C, $0C, $0C, $0D, $0D, $0D, $0D,
	$0E, $0E, $0E, $0E, $0F, $0F, $0F, $0F,
	$10, $10, $10, $10, $11, $11, $11, $11,
	$12, $12, $12, $12, $13, $13, $13, $13,
	$14, $14, $14, $14, $15, $15, $15, $15,
	$16, $16, $16, $16, $17, $17, $17, $17,
	$18, $18, $19, $19, $1A, $1A, $1B, $1B,
	$1C, $1C, $1D, $1D, $1E, $1E, $1F, $1F,
	$20, $20, $21, $21, $22, $22, $23, $23,
	$24, $24, $25, $25, $26, $26, $27, $27,
	$28, $28, $29, $29, $2A, $2A, $2B, $2B,
	$2C, $2C, $2D, $2D, $2E, $2E, $2F, $2F,
	$30, $31, $32, $33, $34, $35, $36, $37,
	$38, $39, $3A, $3B, $3C, $3D, $3E, $3F);

 d_len: array[0..$FF] of byte = (
  $03, $03, $03, $03, $03, $03, $03, $03,
	$03, $03, $03, $03, $03, $03, $03, $03,
	$03, $03, $03, $03, $03, $03, $03, $03,
	$03, $03, $03, $03, $03, $03, $03, $03,
	$04, $04, $04, $04, $04, $04, $04, $04,
	$04, $04, $04, $04, $04, $04, $04, $04,
	$04, $04, $04, $04, $04, $04, $04, $04,
	$04, $04, $04, $04, $04, $04, $04, $04,
	$04, $04, $04, $04, $04, $04, $04, $04,
	$04, $04, $04, $04, $04, $04, $04, $04,
	$05, $05, $05, $05, $05, $05, $05, $05,
	$05, $05, $05, $05, $05, $05, $05, $05,
	$05, $05, $05, $05, $05, $05, $05, $05,
	$05, $05, $05, $05, $05, $05, $05, $05,
	$05, $05, $05, $05, $05, $05, $05, $05,
	$05, $05, $05, $05, $05, $05, $05, $05,
	$05, $05, $05, $05, $05, $05, $05, $05,
	$05, $05, $05, $05, $05, $05, $05, $05,
	$06, $06, $06, $06, $06, $06, $06, $06,
	$06, $06, $06, $06, $06, $06, $06, $06,
	$06, $06, $06, $06, $06, $06, $06, $06,
	$06, $06, $06, $06, $06, $06, $06, $06,
	$06, $06, $06, $06, $06, $06, $06, $06,
	$06, $06, $06, $06, $06, $06, $06, $06,
	$07, $07, $07, $07, $07, $07, $07, $07,
	$07, $07, $07, $07, $07, $07, $07, $07,
	$07, $07, $07, $07, $07, $07, $07, $07,
	$07, $07, $07, $07, $07, $07, $07, $07,
	$07, $07, $07, $07, $07, $07, $07, $07,
	$07, $07, $07, $07, $07, $07, $07, $07,
	$08, $08, $08, $08, $08, $08, $08, $08,
	$08, $08, $08, $08, $08, $08, $08, $08);

var
  freq: array [0..T] of Cardinal;
  prnt: array [0..T + N_CHAR - 1] of integer;
  son: array [0..T - 1] of integer;
  getbuf: Cardinal;
  getlen: byte;
  textsize, codesize, printcount: Cardinal;
  text_buf: array[0..N + F - 2] of Byte;
  match_position, match_length: integer;
  lson, dad: array[0..N] of integer;
  rson: array[0..N + $100] of integer;
  putbuf: cardinal;
  putlen: Byte;

procedure Clear;
begin
FillChar(freq[0], (T + 1) * SizeOf(cardinal), 0);
FillChar(prnt[0], (T + N_CHAR) * SizeOf(integer), 0);
FillChar(son[0], T * SizeOf(integer), 0);
  getbuf := 0;
  getlen := 0;
  textsize := 0;
  codesize := 0;
  printcount := 0;
FillChar(text_buf[0], (N + F - 1) * SizeOf(byte), 0);
  match_position := 0;
  match_length := 0;
FillChar(lson[0], (N + 1) * SizeOf(integer), 0);
FillChar(dad[0], (N + 1) * SizeOf(integer), 0);
FillChar(rson[0], (N + $101) * SizeOf(integer), 0);
  putbuf := 0;
  putlen := 0;
end;

procedure InitTree;
var
  i: Integer;
begin
  for i:= N + 1 to N + $100 do
  rson[i] := NUL;

  for i := 0 to N - 1 do
  dad[i] := NUL;
end;

procedure InsertNode(r: integer);
var
  i, p, cmp: integer;
  //key: PByteArray;
  key: PByte;
  c: cardinal;
begin
  cmp := 1;
  key := @text_buf[r];
  p := N + 1 + key^;
  rson[r] := NUL;
  lson[r] := NUL;
  match_length := 0;

  while True do
  begin
    if cmp >= 0 then
    begin
      if rson[p] <> NUL then
      p := rson[p]
      else
      begin
        rson[p] := r;
        dad[r] := p;
        Exit;
      end;
    end
    else
    begin
      if lson[p] <> NUL then
      p := lson[p]
      else
      begin
        lson[p] := r;
        dad[r] := p;
        Exit;
      end;
    end;

    for i:= 1 to F - 1 do
      if (PByte(Cardinal(key) + i)^ - text_buf[p + i]) <> 0 then
      Break;

    if i > THRESHOLD then
    begin
      if i > match_length then
      begin
        match_position := ((r - p) and (N - 1)) - 1;
        match_length := i;
        if match_length >= F then
        Break;
      end;
      if i = match_length then
      begin
        c := ((r - p) and (N - 1)) - 1;
        if c < cardinal(match_position) then
        match_position := c;
      end;
    end;
  end;
    dad[r] := dad[p];
    lson[r] := lson[p];
    rson[r] := rson[p];
    dad[lson[p]] := r;
    dad[rson[p]] := r;

    if rson[dad[p]] = p then
    rson[dad[p]] := r
    else
    lson[dad[p]] := r;

    dad[p] := NUL;
end;

procedure DeleteNode(p: integer);
var
  q: integer;
begin
  if dad[p] = NUL then
  Exit;

  if rson[p] = NUL then
  q := lson[p]
  else
  if lson[p] = NUL then
  q := rson[p]
  else
  begin
    q := lson[p];
    if rson[q] <> NUL then
    begin
      repeat
        q := rson[q];
      until (rson[q] = NUL);

      rson[dad[q]] := lson[q];
      dad[lson[q]] := dad[q];
      lson[q] := lson[p];
      dad[lson[p]] := q;
    end;
    rson[q] := rson[p];
    dad[rson[p]] := q;
  end;
  dad[q] := dad[p];
  if rson[dad[p]] = p then
  rson[dad[p]] := q
  else
  lson[dad[p]] := q;
  dad[p] := NUL;
end;

function GetBit(infile: PStream): integer;
var
  i: Cardinal;
  buf: byte;
begin
  while getlen <= 8 do
  begin
    if infile.Read(buf, 1) = 0 then
    i := 0
    else
    i := buf;
    getbuf := getbuf or (i shl (8 - getlen));
    inc(getlen, 8);
  end;

  i := getbuf;
  getbuf := getbuf shl 1;
  dec(getlen);
  Result := (i and $8000) shr 15;
end;

function GetByte(infile: PStream): Integer;
var
  i: cardinal;
  buf: byte;
begin
  while getlen <= 8 do
  begin
    if infile.Read(buf, 1) = 0 then
    i := 0
    else
    i := buf;
    getbuf := getbuf or (i shl (8 - getlen));
    inc(getlen, 8);
  end;
  i := getbuf;
  getbuf := getbuf shl 8;
  dec(getlen, 8);
  Result := (i and $FF00) shr 8;
end;

procedure PutCode(outfile: PStream; l: Integer; c: cardinal);
var
  buf: byte;
begin
  putbuf := putbuf or (c shr putlen);
  putlen := putlen + l;
  if putlen >= 8 then
  begin
    buf := byte(putbuf shr 8);
    outfile.Write(buf, 1);

    dec(putlen, 8);
    if putlen >= 8 then
    begin
      buf := byte(putbuf);
      outfile.Write(buf, 1);
      inc(codesize, 2);
      dec(putlen, 8);
      putbuf := c shl (l - putlen);
    end
    else
    begin
      putbuf := putbuf shl 8;
      Inc(codesize);
    end;
  end;
end;

{* initialization of tree *}

procedure StartHuff;
var
  i, j: integer;
begin
  for i:= 0 to N_CHAR - 1 do
  begin
    freq[i] := 1;
    son[i] := i + T;
    prnt[i + T] := i;
  end;

  i := 0;
  j := N_CHAR;

  while j <= ROOT do
  begin
    freq[j] := freq[i] + freq[i + 1];
    son[j] := i;
    prnt[i] := j;
    prnt[i + 1] := j;
    Inc(i, 2);
    Inc(j);
  end;
  freq[T] := $FFFF;
  prnt[ROOT] := 0;
end;

(* reconstruction of tree *)

procedure reconst;
var
  i, j, k: integer;
  f, l: Cardinal;
begin
  j := 0;
  for i:= 0 to T - 1 do
    if son[i] >= T then
    begin
      freq[j] := (freq[i] + 1) div 2;
      son[j] := son[i];
      Inc(j);
    end;

  i := 0;
  j := N_CHAR;

  while j < T do
  begin
    k := i + 1;
    f := freq[i] + freq[k];
    freq[j] := f;
    k := j - 1;

    while f < freq[k] do
    Dec(k);

    Inc(k);
    l := (j - k) * 2;
    Move(freq[k + 1], freq[k], l);
    freq[k] := f;
    Move(son[k + 1], son[k], l);
    son[k] := i;
    Inc(i, 2);
    Inc(j);
  end;

  for i:= 0 to T - 1 do
  begin
    k := son[i];
    if k >= T then
    prnt[k] := i
    else
    begin
    prnt[k] := i;
    prnt[k + 1] := i;
    end;
  end;
end;

(* increment frequency of given code by one, and update tree *)

procedure update(c: integer);
var
  i, j, k, l: integer;
begin
  if freq[ROOT] = MAX_FREQ then
  reconst;

  c := prnt[c + T];
  repeat
    Inc(freq[c]);
    k := freq[c];
    l := c + 1;
    if Cardinal(k) > freq[l] then
    begin
      repeat
        Inc(l);
      until not (Cardinal(k) > freq[l]);

      Dec(l);
      freq[c] := freq[l];
      freq[l] := k;

      i := son[c];
      prnt[i] := l;
      if i < T then
      prnt[i + 1] := l;

      j := son[l];
      son[l] := i;

      prnt[j] := c;
      if j < T then
      prnt[j + 1] := c;
      son[c] := j;

      c := l;
    end;

    c := prnt[c];
  until (c = 0);
end;

procedure EncodeChar(outfile: PSTream; c: Cardinal);
var
  i: Cardinal;
  j, k: integer;
begin
  i := 0;
  j := 0;
  k := prnt[c + T];

  repeat
    i := i shr 1;

    if (k and 1) = 1 then
    i := i + $8000;

    Inc(j);

    k := prnt[k];
  until (k = ROOT);

  PutCode(outfile, j, i);
  //code := i;
  //len := j;
  update(c);
end;

procedure EncodePosition(outfile: PStream; c: cardinal);
var
  i: Cardinal;
begin
  i := c shr 6;
  PutCode(outfile, p_len[i], Cardinal(p_code[i]) shl 8);

  PutCode(outfile, 6, (c and $3F) shl 10);
end;

procedure EncodeEnd(outfile: PStream);
var
  buf: byte;
begin
  if putlen <> 0 then
  begin
    buf := Byte(putbuf shr 8);
    outfile.Write(buf, 1);
  end;

  inc(codesize);
end;

function DecodeChar(infile: PStream): integer;
var
  c: Cardinal;
begin
  c := son[ROOT];

  while c < T do
  begin
    c := c + GetBit(infile);
    c := son[c];
  end;

  c := c - T;
  update(c);
  result := c;
end;

function DecodePosition(infile: PStream): integer;
var
  i, j, c: Cardinal;
begin
  i := GetByte(infile);
  c := Cardinal(d_code[i]) shl 6;
  j := d_len[i];

  Dec(j, 2);
  while j <> 0 do
  begin
    i := (i shl 1) + GetBit(infile);
    Dec(j);
  end;

  result := c or (i and $3F);
end;

(* compression *)

procedure EncodeLZH(infile, outfile: PStream; Size: cardinal);
var
  i, r, s, length, last_match_length: integer;
  buf: byte;
begin
  Clear;
  try
  if Size = 0 then
  Exit;

  textsize := 0;
  StartHuff;
  InitTree;
  s := 0;
  r := N - F;

  for i := s to r - 1 do
  text_buf[i] := $20;

  length := 0;

  while (length < F) and (infile.Read(buf, 1) > 0) do
  begin
    text_buf[r + length] := buf;
    Inc(length);
  end;

  textsize := length;
  for i:= 1 to F do
  InsertNode(r - i);

  InsertNode(r);

  repeat
    if match_length > length then
    match_length := length;

    if match_length <= THRESHOLD then
    begin
      match_length := 1;
      EncodeChar(outfile, text_buf[r]);
    end
    else
    begin
      EncodeChar(outfile, $FF - THRESHOLD + match_length);
      EncodePosition(outfile, match_position);
    end;

    last_match_length := match_length;
    i := 0;

    while (i < last_match_length) and (infile.Read(buf, 1) > 0) do
    begin
      DeleteNode(s);
      text_buf[s] := Byte(buf);
      if s < F - 1 then
      text_buf[s + N] := Byte(buf);
      s := (s + 1) and (N - 1);
      r := (r + 1) and (N - 1);
      InsertNode(r);
      Inc(i);
    end;

    textsize := textsize + i;
    if textsize > printcount then
    begin
      //Writeln(textsize);
      Inc(printcount, $400);
    end;

    while i < last_match_length do
    begin
      Inc(i);
      DeleteNode(s);
      s := (s + 1) and (N - 1);
      r := (r + 1) and (N - 1);
      Dec(length);
      if length <> 0 then InsertNode(r);
    end;

  until not (length > 0);
  EncodeEnd(outfile);
  finally

  end;
end;

procedure DecodeLZH(infile, outfile: PStream; size: cardinal);
var
  i, j, k, r, c: integer;
  count: Cardinal;
  buf: byte;
begin
  Clear;
  try
  textsize := size;
  if textsize = 0 then Exit;

  StartHuff;

  for i:= 0 to N - F - 1 do
  text_buf[i] := $20;

  r := N - F;
  count := 0;

  while count < textsize do
  begin
    c := DecodeChar(infile);
    if c < $100 then
    begin
      buf := byte(c);
      outfile.Write(buf, 1);
      text_buf[r] := Byte(c);
      Inc(r);
      r := r and (N - 1);
      Inc(count);
    end
    else
    begin
      i := (r - DecodePosition(infile) - 1) and (N - 1);
      j := c - $FF + THRESHOLD;

      for k := 0 to j - 1 do
      begin
        c := text_buf[(i + k) and (N - 1)];
        buf := byte(c);
        outfile.Write(buf, 1);
        text_buf[r] := Byte(c);
        Inc(r);
        r := r and (N - 1);
        Inc(count);
      end;
    end;

    if count > printcount then
    begin
      //Writeln(count);
      Inc(printcount, $400);
    end;
  end;
  finally

  end;
end;

function Ceil(X: Extended): Integer;
begin
  Result := Integer(Trunc(X));
  if Frac(X) > 0 then
    Inc(Result);
end;

function Swap32(Value: cardinal): cardinal; register;
asm
  bswap eax
end;

function Swap16(Value: word): word; register;
asm
  xchg  al, ah
end;

function GetNibble(b: Byte; Nb: TNibble): Byte;  //Get Left or Right nibble
begin
  if Nb = nbLeft then
    result := (b and $F0) shr 4
  else
    result := (b and $0F);
end;

procedure EncodeRLE(uncprStream, cprStream: PStream; Size: cardinal);
var
  i, z, j: cardinal;
  bufb: byte;
  bufw: word;
  bufc: Cardinal;
  NC: word;
  Lnib, Rnib: byte;
  nibArr: array of byte;
  cntArr: array of cardinal;
begin
  Clear;
  try
  cprStream.Seek(4, spBegin);
  SetLength(nibArr, 0);
  uncprStream.Seek(0, spBegin);
  i := 0;
  j := 0;

  while j < Size do
  begin
    uncprStream.Read(bufb, 1);
    Lnib := GetNibble(bufb, nbLeft);
    Rnib := GetNibble(bufb, nbRight);

    SetLength(nibArr, Length(nibArr) + 2);
    nibArr[i] := Lnib;
    nibArr[i + 1] := Rnib;
    Inc(i, 2);
    Inc(j);
  end;

  i := 0;
  SetLength(cntArr, 0);

  while i <= cardinal(High(nibArr)) do
  begin
    if nibArr[i] = nibArr[i + 1] then
    begin
      if i = 0 then
      SetLength(cntArr, Length(cntArr) + 1);
      if (i <> 0) and (nibArr[i] <> nibArr[i - 1]) then
        SetLength(cntArr, Length(cntArr) + 1);
      cntArr[High(cntArr)] := cntArr[High(cntArr)] + 2;
    end
    else if (i <> 0) and (nibArr[i] = nibArr[i - 1])  then
    begin
      cntArr[High(cntArr)] := cntArr[High(cntArr)] + 1;
      SetLength(cntArr, Length(cntArr) + 1);
      cntArr[High(cntArr)] := 1;
    end
    else //if (i <> 0) and (nibArr[i] <> nibArr[i - 1]) then
    begin
      SetLength(cntArr, Length(cntArr) + 1);
      cntArr[High(cntArr)] := 1;
      SetLength(cntArr, Length(cntArr) + 1);
      cntArr[High(cntArr)] := 1;
    end;
    Inc(i, 2);
  end;

  for z := 0 to High(cntArr) do
  dec(cntArr[z]);

  i := 0;
  z := 0;

  while z <= cardinal(High(cntArr)) do
  begin
    if (cntArr[z] < $D) then
    begin
      NC := (nibArr[i] shl 4) + cntArr[z];
      cprStream.Write(NC, 1);
    end
    else
    if (cntArr[z] >= $D) and (cntArr[z] <= $FF) then
    begin
      NC := (nibArr[i] shl 4) + $D;
      cprStream.Write(NC, 1);
      bufb := cntArr[z];
      cprStream.Write(bufb, 1);
    end
    else
    if (cntArr[z] >= $100) and (cntArr[z] <= $FFFF) then
    begin
      NC := (nibArr[i] shl 4) + $E;
      cprStream.Write(NC, 1);
      bufw := swap16(cntArr[z]);
      cprStream.Write(bufw, 2);
    end
    else
    if (cntArr[z] >= $10000) and (cntArr[z] <= $1FFFF) then
    begin
      NC := (nibArr[i] shl 4) + $0F;
      cprStream.Write(NC, 1);
      bufw := $FFFF;
      cprStream.Write(bufw, 2);
    end
    else
    if cntArr[z] >= $20000 then
    begin
      MessageBox(0, PAnsiChar('Unsupported repeat count: ' +
      Int2Str(cntArr[z])), 'Error', MB_OK + MB_ICONSTOP + MB_TOPMOST);
      Break;
    end;
    Inc(i, cntArr[z] + 1);
    Inc(z);
  end;

  cprStream.Seek(0, spBegin);
  Size := ceil(Size / 4) * 4;
  bufc := Swap32(Size);
  cprStream.Write(bufc, 4);
  cntArr := nil;
  nibArr := nil;
  finally

  end;
end;

procedure DecodeRLE(cprStream, uncprStream: PStream; offset: cardinal);
var
  bufb: byte;
  DW, RNib, LNib, BtCount, NbCount, UnpackedSize4: cardinal;
  bufc: cardinal;
  bufw: word;
  UnpackedOhtsuka: array of cardinal;
begin
  Clear;
  try
  cprStream.Read(bufc, 4);
  bufc := Swap32(bufc);
  UnpackedSize4 := bufc shr 2;  //shr 2
  BtCount := 8;
  DW := offset;

  while True do
  begin
    cprStream.Read(bufb, 1);
    LNib := bufb shr 4; //Left Nibble
    RNib := bufb and $F;//Right Nibble

    if RNib < $D then
      NbCount := RNib
    else
    if RNib = $D then
    begin
      cprStream.Read(bufb, 1);
      NbCount := bufb;
    end
    else
    if RNib = $E then
    begin
      cprStream.Read(bufw, 2);
      NbCount := Swap16(bufw);
    end
    else
    begin
      cprStream.Read(bufw, 2);
      NbCount := $10000 + Swap16(bufw);
    end;

    while True do
    begin
      DW := (DW shl 4) or LNib;
      Dec(BtCount);
      if (BtCount = 0) then
      begin
        SetLength(UnpackedOhtsuka, Length(UnpackedOhtsuka) + 1);
        UnpackedOhtsuka[High(UnpackedOhtsuka)] := Swap32(DW);
        BtCount := 8;
        Dec(UnpackedSize4);
        if (UnpackedSize4 = 0) then
        begin
          uncprStream.Write(UnpackedOhtsuka[0], Length(UnpackedOhtsuka) * 4);
          SetLength(UnpackedOhtsuka, 0);
          UnpackedOhtsuka := nil;
          Exit;
        end;
      end;
      if NbCount = 0 then
        Break;
      Dec(NbCount);
    end;
  end;
  finally

  end;
end;

end.
 