program pbunpack;

{$APPTYPE CONSOLE}

uses
  KOLAdd, KOL;

procedure Text;
begin
  Writeln(
  '-= PB Archives (Front Mission 2) Extractor Tool v1.0 [by Lab313] =-'+#13#10+
  '----------------------------------'+#13#10+
  'Analysis: AID_X'+#13#10+
  'Coding: Dr. MefistO'+#13#10+
  'Our site: http://lab313.ru'+#13#10+
  '----------------------------------'+#13#10#13#10+
  'This tool decompresses RLE-packed archives with PB-tag [50 42 00 00].'+
  #13#10#13#10+
  'USAGE: pbunpack.exe ZDATA.BIN'+#13#10+
  'ZDATA.BIN: file from "Front Mission 2" game.'+#13#10
  );
end;

var
  pFile, pStart: PByte;
  hFile,hMap: THandle;
  i, z, k: Cardinal;
  buf_c: Cardinal;
  RRRR: Word;
  RR, CC, RepCount: byte;
  PBsize: cardinal;
  extrbuf: array[1..$FFFF] of byte;
  extr: PStream;
  flsz, startpos: cardinal;
begin

  flsz := FileSize(ParamStr(1));
  CreateDirectory(PAnsiChar(ExtractFilePath(ParamStr(0))+'tims'),nil);
  if (not DirectoryExists(ExtractFilePath(ParamStr(0))+'tims')) or
  (not FileExists(ParamStr(1))) then
  begin
  Text;
  Exit;
  end;

  pFile:=MapFileRead(ParamStr(1),hFile, hMap);
  pStart:=pFile;

  while (Cardinal(pFile)-cardinal(pStart)) < flsz-1 do
  begin
    try
    startpos := Cardinal(pFile)-cardinal(pStart);
    z:=1;
    k:=0;

    Move(pFile^,buf_c,4);

    if buf_c <> $4250 then
    begin
      Inc(pFile);
      Continue;
    end;
    Inc(pFile,4);

    Move(pFile^,PBsize,4);

    PBsize:=PBsize-8;
    if PBsize>flsz then
    begin
      Inc(pFile);
      Continue;
    end;
    if PBsize = 0 then
    begin
      Inc(pFile);
      Continue;
    end;
    Inc(pFile,4);

    extr := NewMemoryStream;
    while (k+1) < PBsize-1 do
    begin
      cc := pFile^;
      Inc(pFile);
      inc(k);

      case CC of
        $00..$3F:
          begin
            RepCount := CC + 1;

            for i := 1 to RepCount do
            begin
              RR := pFile^;
              extrbuf[z] := RR;
              Inc(z);
              extr.Write(RR, 1);
              Inc(pFile);
              Inc(k);
            end;
          end;
        $40..$7F:
          begin
            RepCount := CC - $40 + 3;
            RR := pFile^;
            for i := 1 to RepCount do
            begin
              extrbuf[z] := RR;
              Inc(z);
              extr.Write(RR, 1);
            end;
            Inc(pFile);
            Inc(k);
          end;
        $80..$BF:
          begin
            RepCount := CC - $80 + 2;
            RR := pFile^;

            for i := 1 to RepCount do
            begin
              extrbuf[z] := extrbuf[z - RR];
              extr.Write(extrbuf[z - RR], 1);
              Inc(z);
            end;
            Inc(pFile);
            Inc(k);
          end;
        $C0..$FF:
          begin
            RepCount := CC - $C0 + 2;
            Move(pFile^, RRRR, 2);

            for i := 1 to RepCount do
            begin
              extrbuf[z] := extrbuf[z - RRRR];
              extr.Write(extrbuf[z - RRRR], 1);
              Inc(z);
            end;
            Inc(pFile, 2);
            Inc(k,2);
          end;
      end;
    end;  
      extr.Seek(0, spBegin);
      extr.Read(buf_c, 4);
      Writeln('tims\'+Int2hex(startpos, 6) + '.tim succefully extracted!');
      extr.SaveToFile(ExtractFilePath(ParamStr(0))+'tims\'+Int2hex(startpos, 6) + '.tim', buf_c, extr.size-buf_c);
      extr.free;
    except
      extr.free;
      Break;
    end;      
  end;
  UnmapFile(pStart, hFile, hMap);
  Readln;
end.

