#!/usr/bin/perl
package Hex;
use strict;
use FindBin;
use lib "$FindBin::Bin";
use Cwd;
use Cwd qw(abs_path);
use File::Path;
use Hex::Editor;
use Hex::FileSelect;
use Win32::Console;
use Math::BaseCalc;
use File::Spec;
use File::Copy;

our $BIN_DIR = $FindBin::Bin;
our $INI_FILE = File::Spec->catfile($BIN_DIR, 'jinx.ini');
our $FAV_FILE = File::Spec->catfile($BIN_DIR, 'jinx.fav');
our $TBL_DIR;
our $FILENAME;
our $BACKUP_DIR;
our $BACKUP;
#our $MOD_DIR;
our $ROM_DIR;
our %CONFIG;

Init();
our $INPUT_CONSOLE = new Win32::Console(STD_INPUT_HANDLE);
unless(@ARGV) {
    my $FS = new Hex::FileSelect;
    $FS->Title("Choose a file to open.");
    $FS->Start($ROM_DIR);
    $FILENAME = $FS->Run();

    if($FILENAME eq '') {
        exit;
    }
}else{
    $FILENAME = shift;
}

print "Loading $FILENAME...\n";
our $Editor = new Hex::Editor;
$Editor->Run($FILENAME);

sub Init {
    print "Initializing.\n";
    print "Current Dir: $BIN_DIR\n";
    print "Ini: $INI_FILE\n";

    Config();
    $TBL_DIR = $CONFIG{TBL_DIR};
    $BACKUP_DIR = $CONFIG{BACKUP_DIR};
#    $MOD_DIR = $CONFIG{MOD_DIR};
    $ROM_DIR = $CONFIG{ROM_DIR};
    $BACKUP = $CONFIG{BACKUP};

    foreach($TBL_DIR, $BACKUP_DIR, $ROM_DIR) { #convert to abs paths
        ( File::Spec->splitpath($_) )[0]
         or $_ = abs_path(File::Spec->catfile($BIN_DIR, $_));
        warn "$_ is not a directory\n" unless(-d $_); 
    }    

    print "Table File File Directory: $TBL_DIR\n";
    print "Backup Directory: $BACKUP_DIR\n";
#    print "Module Directory: $MOD_DIR\n";
    print "Rom Directory: $ROM_DIR\n";
    print "Backup?: $BACKUP\n";
    mkpath($TBL_DIR);
    mkpath($BACKUP_DIR);

    printf "%+60s", "Done\n";
}

sub Config {
    print "Reading configuration file.\n";
    open(INI, "$INI_FILE") || die "Error opening $INI_FILE: $!\n";
    while(<INI>) {
        if(/^(\w+)=(.+)$/) {
            $CONFIG{$1} = $2;
        }
    }
    close INI;
    printf "%+60s", "Done\n";
}

