#!/usr/bin/perl
package Hex::TableFile;
use strict;
use Math::BaseCalc;

sub new {
    my $class = shift;
    my $self = {
        Base16 => new Math::BaseCalc(digits => 'HEX'),
        Forward => {},   # Value => Char
        Reverse => {},   # Char => Value
    };
    bless($self, $class);
    return $self;
}

sub LoadFile { #returns an error message on error
    my($self, $path) = @_;
    my %forward = ();
    my %reverse = ();

    open(TBL, $path) || return "Can't open table file: $!";
    while(<TBL>) {
        chomp;
        my($hex, $char) = split(/=/, $_, 2);
        $hex = uc $hex;
        return "Invalid Hex value at line $." if($hex =~ /[^0-9A-F]/);
        my $value = $self->{Base16}->from_base($hex);
        if(defined $forward{$value}) {
            close TBL;
            return "Hex value $hex redefined at line $.";
        }

        if(defined $reverse{$char}) {
            close TBL;            
            return "Char value \"$char\" redefined at line $.";
        }

        if($char ne '') {
            $forward{$value} = $char;
            $reverse{$char} = $value;
        }
    }
    %{ $self->{Forward} } = %forward;
    %{ $self->{Reverse} } = %reverse;
    close TBL;    
    return 0;
}

sub HexStr2Len { #gets length of character string produced by hex string
                 #zerovalue is how much unknown hex values add to the length
    my($self, $hex, $zerovalue) = @_;
    $hex = uc $hex;
    my @bytes = $hex =~ /../g;
    my $length = 0;
    foreach(@bytes) {
        if(defined(my $c = $self->Hex2Char($_))) {
            $length += length($c);
        }else{
            $length += $zerovalue;
        }    
    }
    return $length;
}
sub Hex2Char {
    my($self, $hex) = @_;
    $hex = uc $hex;  
    return $self->{Forward}->{ $self->{Base16}->from_base($hex) };
};
sub Dec2Char {
    my($self, $value) = @_;
    return $self->{Forward}->{$value};
};
sub Char2Hex {
    my($self, $char) = @_;
    return undef unless(defined $self->{Reverse}->{$char});
    return $self->{Base16}->to_base( $self->{Reverse}->{$char} );
};
sub Char2Dec {
    my($self, $char) = @_;
    return $self->{Reverse}->{$char};
};
1;
