#!/usr/bin/perl
package Hex::Replace;
use strict;
use Win32::Console;

sub new {
    my $class = shift;
    my $self = {
        Output => new Win32::Console,
        Input  => $Hex::INPUT_CONSOLE,
        UserText => '', #what the user types
        HexText  => '', #hex that the user sees
        Replacement => '', #true characters that will be inserted
        Compress  => '1', # false = normal mode, true = compressed mode
        Even  => 1, #true if all the text compressed right
        Table => '', #Hex::TableFile object
        Length => '', #Length of return string.
        Handler => {
            '8'  => \&_kBkSpace,
            '13' => \&_kEnter,
#unneeded   '27' => \&_kEsc, 
            '37' => \&_kLeft,
            '39' => \&_kRight,
            'Char' => \&_kChar,
        },
    };
    bless($self, $class);
    return $self;
}

sub Run {
    my($self, $table, $length) = @_;
    $self->{Input}->Cursor(0,0,0,0);    
    my $stop;
    $self->{Table} = $table;
    $self->{Length} = $length;
    $self->_Draw();
    $self->_Update();
    $self->{Input}->Flush();
    while(1) {
        if($self->{Input}->GetEvents()) {
            my @event = $self->{Input}->Input();
            if($event[1] && $event[3] == 27) { #esc
                return undef;
            }            
            elsif($event[1] && defined $self->{Handler}->{$event[3]}) {
                $stop = $self->{Handler}->{$event[3]}->($self);
            }elsif($event[1] && $event[5]){
                $stop = $self->{Handler}->{Char}->($self, chr($event[5]));
            }    
            if($stop) {
                return $self->{Replacement};
            }
        }
    }
}

sub _kEnter { #all set
    return 1;
}
sub _kBkSpace {
    my($self) = @_;
    chop $self->{UserText};
    $self->_ReCompile();
    $self->_Update();
    return 0;
}
sub _kLeft {
    my($self) = @_;
    $self->_SwitchMode();
    return 0;    
}
sub _kRight {
    my($self) = @_;
    $self->_SwitchMode();
    return 0;
}
sub _kChar {
    my($self, $char) = @_;
   #could have used Char2Hex(), but why do the unneeded conversion
   # return 0 unless(defined $self->{Table}->Char2Dec($char));

    $self->{UserText} .= $char;
    $self->_ReCompile();
    $self->_Update();
    return 0;
}

sub _ReCompile { #recalculates $self->{Replacement} and $self->{HexText}
    my($self) = @_;
    my $text = $self->{UserText};
    my $chunk;
    my $replacement;
    my $hextext;
    
    if($self->{Compress}) { #compress mode
        while(($chunk = $self->_GetBiggestChunk($text)) ne '') {
            substr($text, 0, length($chunk), '');
            my $hexvalue = $self->{Table}->Char2Hex($chunk);
            $replacement .= pack('H*', $hexvalue);
            $hextext .= sprintf('%02s', $hexvalue);        }
    }else{ #lame normal mode
        while(($chunk = $self->_GetSmallestChunk($text)) ne '') {
            substr($text, 0, length($chunk), '');
            my $hexvalue = $self->{Table}->Char2Hex($chunk);
            $replacement .= pack('H*', $hexvalue);
            $hextext .= sprintf('%02s', $hexvalue);
        }
    }
    
    $self->{Replacement} = $replacement;
    $self->{HexText} = $hextext;
    
    if($text ne '') { #if we have leftover text..
        $self->{Even} = 0;
    }else{
        $self->{Even} = 1;
    }    
}

sub _GetBiggestChunk {
    my($self, $text) = @_;
    while($text ne '') {
        my $value = $self->{Table}->Char2Dec($text);
        if(defined $value) {
            return $text;
        }else{
            chop $text;
        }    
    }
    return '';
}

sub _GetSmallestChunk {
    my($self, $text) = @_;
    my $length = 1;
    while($length <= length($text)) {
        my $value = $self->{Table}->Char2Dec(substr($text, 0, $length));
        if(defined $value) {
            return substr($text, 0, $length);
        }else{
            $length++;;
        }
    }
    return '';
}

sub _SwitchMode {
    my($self) = @_;
    $self->{Compress} ^= 1;
    $self->_ReCompile();
    $self->_Update();
}

sub _Draw { # 80 x 6
    my($self) = @_;
    $self->{Output}->Size(80, 50);
    $self->{Output}->FillAttr($main::BG_BLACK | $main::FG_GRAY, 80 * 50, 0, 0);
    $self->{Output}->FillChar(' ', 80 * 50, 0, 0);

   #Title Bar
    $self->{Output}->FillAttr($main::BG_LIGHTBLUE | $main::FG_LIGHTCYAN, 80, 0, 22);
   #Body
    $self->{Output}->FillAttr($main::BG_BLUE | $main::FG_WHITE, 80 * 5, 0, 23);
   #'Text boxes'
    $self->_DrawTextBoxes();
   #Window Text
    $self->{Output}->WriteChar('Replacement Text:', 1, 23);
    $self->{Output}->WriteChar('Hexidecimal Representation:', 1, 25);
    $self->{Output}->Display();

}

sub _DrawTextBoxes {
    my($self) = @_;
    if($self->{Even}) {
        $self->{Output}->FillAttr($main::BG_BLACK | $main::FG_LIGHTGREEN, 78, 1, 24);
        $self->{Output}->FillAttr($main::BG_BLACK | $main::FG_LIGHTGREEN, 78, 1, 26);
    }else{
        $self->{Output}->FillAttr($main::BG_BLACK | $main::FG_LIGHTRED, 78, 1, 24);
        $self->{Output}->FillAttr($main::BG_BLACK | $main::FG_LIGHTRED, 78, 1, 26);
    }
}

sub _Update {
    my($self) = @_;
   #Title
    my $titlebar = 'Edit Mode'; #9 chars
    my $maxbytes = $self->{Length};
    my $usedbytes = length($self->{Replacement});
    my $bytesusedphrase = "$usedbytes/$maxbytes bytes used";
    my $titlebar = $titlebar . sprintf('%*s', 80 - length($titlebar), $bytesusedphrase);
    if($usedbytes > $maxbytes) {
        $self->{Output}->FillAttr(
                         $main::BG_LIGHTBLUE | $main::FG_LIGHTRED,
                         length($bytesusedphrase),
                         80 - length($bytesusedphrase), 22);
    }else{
        $self->{Output}->FillAttr(
                         $main::BG_LIGHTBLUE | $main::FG_LIGHTCYAN,
                         length($bytesusedphrase),
                         80 - length($bytesusedphrase), 22);
    }
    $self->{Output}->WriteChar($titlebar, 0, 22);
    $self->_DrawTextBoxes();
   #UserText
    if(length($self->{UserText}) > 78) {
        $self->{Output}->WriteChar(
                         '...' . substr($self->{UserText}, length($self->{UserText}) - 75), 1, 24);
    }else{
        $self->{Output}->WriteChar(sprintf('%-78s', $self->{UserText}), 1, 24);
    }
   #HexText
    if(length($self->{HexText}) > 78) {
        $self->{Output}->WriteChar(
                         '...' . substr($self->{HexText}, length($self->{HexText}) - 75), 1, 26);
    }else{
        $self->{Output}->WriteChar(sprintf('%-78s', $self->{HexText}), 1, 26);
    }
   #Mode
    if($self->{Compress}) {
        $self->{Output}->WriteChar(sprintf('%80s', 'Mode: [Compress] Normal '), 0, 27);
    }else{
        $self->{Output}->WriteChar(sprintf('%80s', 'Mode:  Compress [Normal]'), 0, 27);
    }
}
1;
