#!/usr/bin/perl
package Hex::RelSearch;
use strict;
use Win32::Console;
use Math::BaseCalc;

sub new {
    my($class) = @_;
    my $self = {
        Output => new Win32::Console,
        Input  => $Hex::INPUT_CONSOLE,
        Base16 => new Math::BaseCalc(digits => 'HEX'),
        UserText => '', #what the user types
        HexText  => '', #hex that the user sees
        Values => [], #array of relative values
        Compress  => '1', # false = normal mode, true = compressed mode
        Table => '', #Hex::TableFile object
        Handler => {
            '8'  => \&_kBkSpace,
            '13' => \&_kEnter,
            'Char' => \&_kChar,
        },
    };
    bless($self, $class);
    return $self;
}

sub Run {
    my($self, $table) = @_;
    $self->{Input}->Cursor(0,0,0,0);
    my $stop;
    $self->{Table} = $table;
    $self->_Draw();
    $self->_Update();
    $self->{Input}->Flush();
    while(1) {
        if($self->{Input}->GetEvents()) {
            my @event = $self->{Input}->Input();
            if($event[1] && $event[3] == 27) { #esc
                return undef;
            }            
            elsif($event[1] && defined $self->{Handler}->{$event[3]}) {
                $stop = $self->{Handler}->{$event[3]}->($self);
            }elsif($event[1] && $event[5]){
                $stop = $self->{Handler}->{Char}->($self, chr($event[5]));
            }    
            if($stop) {
                return @{ $self->{Values} };
            }
        }
    }
}

sub _kEnter { #all set
    return 1;
}
sub _kBkSpace {
    my($self) = @_;
    chop $self->{UserText};
    $self->_ReCompile();
    $self->_Update();
    return 0;
}
sub _kChar {
    my($self, $char) = @_;
   #could have used Char2Hex(), but why do the unneeded conversion
   # return 0 unless(defined $self->{Table}->Char2Dec($char));

    $self->{UserText} .= $char;
    $self->_ReCompile();
    $self->_Update();
    return 0;
}

sub _ReCompile { #recalculates $self->{Replacement} and $self->{HexText}
    my($self) = @_;
    my $text = $self->{UserText};
    my $char;
    my @values;
    my $hextext;

    while($text ne '') {
        $char = substr($text, 0, 1, '');
        my $hexvalue = uc(sprintf('%02X', ord($char)));
        $hextext .= $hexvalue;
    }

    while($hextext =~ /(..)(?=(..))/g) { #calc rel values
        my($num1, $num2) = ($self->{Base16}->from_base($1), $self->{Base16}->from_base($2));
        push(@values, $num2 - $num1)
    }

    $self->{HexText} = $hextext;
    @{ $self->{Values} } = @values;
}

sub _Draw { # 80 x 6
    my($self) = @_;
    $self->{Output}->Size(80, 50);
    $self->{Output}->FillAttr($main::BG_BLACK | $main::FG_GRAY, 80 * 50, 0, 0);
    $self->{Output}->FillChar(' ', 80 * 50, 0, 0);

   #Title Bar
    $self->{Output}->FillAttr($main::BG_LIGHTBLUE | $main::FG_LIGHTCYAN, 80, 0, 22);
    $self->{Output}->WriteChar('Relative Search', 0, 22);
   #Body
    $self->{Output}->FillAttr($main::BG_BLUE | $main::FG_WHITE, 80 * 7, 0, 23);
   #'Text boxes'
    $self->_DrawTextBoxes();
   #Window Text
    $self->{Output}->WriteChar('Search Text:', 1, 23);
    $self->{Output}->WriteChar('Hexidecimal Representation (ASCII):', 1, 25);
    $self->{Output}->WriteChar('Relative Values:', 1, 27);
    $self->{Output}->Display();

}

sub _DrawTextBoxes {
    my($self) = @_;
    $self->{Output}->FillAttr($main::BG_BLACK | $main::FG_LIGHTGREEN, 78, 1, 24);
    $self->{Output}->FillAttr($main::BG_BLACK | $main::FG_LIGHTGREEN, 78, 1, 26);
    $self->{Output}->FillAttr($main::BG_BLACK | $main::FG_LIGHTGREEN, 78, 1, 28);
}

sub _Update {
    my($self) = @_;
   #Title
    $self->_DrawTextBoxes();
   #UserText
    if(length($self->{UserText}) > 78) {
        $self->{Output}->WriteChar(
                         '...' . substr($self->{UserText}, length($self->{UserText}) - 75), 1, 24);
    }else{
        $self->{Output}->WriteChar(sprintf('%-78s', $self->{UserText}), 1, 24);
    }
   #HexText
    if(length($self->{HexText}) > 78) {
        $self->{Output}->WriteChar(
                         '...' . substr($self->{HexText}, length($self->{HexText}) - 75), 1, 26);
    }else{
        $self->{Output}->WriteChar(sprintf('%-78s', $self->{HexText}), 1, 26);
    }
   #Rel Values
    my $valuestring = join(',', map {sprintf('%+d', $_)} @{ $self->{Values} });
    if(length($valuestring) > 78) {
        $self->{Output}->WriteChar(
                         '...' . substr($valuestring, length($valuestring) - 75), 1, 28);
    }else{
        $self->{Output}->WriteChar(sprintf('%-78s', $valuestring), 1, 28);
    }
}

1;
