package Hex::Goto;
use strict;
use Win32::Console;
use Math::BaseCalc;

sub new {
    my $class = shift;
    my $self = {
        Input => $Hex::INPUT_CONSOLE,
        Output=> new Win32::Console,
        Txt   => '', #what the user types
        ActiveButton => 0,
        Handler => {
            8  => \&_kBkSpace,
            13 => \&_kEnter,
            32 => \&_kSpaceBar,
            37 => \&_kLeft,
            39 => \&_kRight,
            Char => \&_kChar,
        },
        Base16 => new Math::BaseCalc(digits => 'HEX'),
        Base2 => new Math::BaseCalc(digits => 'bin'),
        Base => 10, # also 16 for hex or 2 for binary
    };
    bless($self, $class);
    return $self;
}

sub Run {   #returns: (offset value, from); from can be 0(start), 1(curloc), or 2(end)
            #or undef on cancel
    my($self) = @_;
    $self->{Input}->Cursor(0,0,0,0);    
    $self->_Draw();
    my $stop = 0;
    $self->{Input}->Flush();
    while(1) {
        if($self->{Input}->GetEvents()) {
            my @event = $self->{Input}->Input();
            if($event[1] && $event[3] == 27) {
                return undef;
            }            
            elsif($event[1] && defined $self->{Handler}->{$event[3]}) {
                $stop = $self->{Handler}->{$event[3]}->($self);
            }elsif($event[1] && $event[5]){
                $stop = $self->{Handler}->{Char}->($self, $event[5]);
            }    
            if($stop) {
                my $offset = $self->_GetOffset();
                if(defined $offset) {
                    return ($offset, $self->{ActiveButton});
                }else{
                    $stop = 0;
                }    
            }
        }
    }
}

sub _GetOffset {
    my($self) = @_;
    if($self->{Base} == 10) {
        if($self->{Txt} =~ /^\d+$/) {
            return $self->{Txt};
        }else{
            $self->_WrongInput();
            return undef;
        }
    }
    elsif($self->{Base} == 16) {
        if($self->{Txt} =~ /^[\dA-Fa-f]+$/) {
            my $offset = $self->{Base16}->from_base(uc($self->{Txt}));
            return $offset;
        }else{
            $self->_WrongInput();
            return undef; 
        }
    }
    elsif($self->{Base} == 2) {
        if($self->{Txt} =~ /^[01]+$/) {
            my $offset = $self->{Base2}->from_base($self->{Txt});
            return $offset;
        }else{
            $self->_WrongInput();
            return undef; 
        }
    }
}

sub _WrongInput { #error
    my($self) = @_;
    my $msg = new Hex::MessageBox(
       "Invalid Input!",
       "You've supplied invalid input, make sure that you\n"
      ."have the right base selected.",
       qw(OK) );
    $msg->Run();
}
sub _kEnter {
    my($self) = @_;
    return 1;
}

sub _kSpaceBar {
    my($self) = @_;
    return 1;
}
sub _kLeft {
    my($self) = @_;
    if($self->{ActiveButton} == 0) {
        $self->{ActiveButton} = 2;
        $self->_UpdateButtons();
    }else{
        $self->{ActiveButton}--;
        $self->_UpdateButtons();        
    }
    return 0;
}
sub _kRight {
    my($self) = @_;
    if($self->{ActiveButton} == 2) {
        $self->{ActiveButton} = 0;
        $self->_UpdateButtons();
    }else{
        $self->{ActiveButton}++;
        $self->_UpdateButtons();
    }
    return 0;    
}
sub _kChar {
    my($self, $char) = @_;
    my %bases = ('%' => 2, '$' => 16, '.' => 10);
    if(chr($char) eq '%' || chr($char) eq '$' || chr($char) eq '.') {
        $self->{Base} = $bases{chr($char)};
        $self->{Output}->WriteChar(chr($char), 25, 25);
    }
    elsif(chr($char) =~ /[\dA-F]/i) {
        $self->{Txt} .= uc chr($char);
        $self->_UpdateText();
    }
    return 0;    
}

sub _kBkSpace {
    my($self) = @_;
    chop $self->{Txt};
    $self->_UpdateText();
    return 0;    
}

sub _Draw {
    my($self) = @_;
    $self->{Output}->FillChar(' ', 80 * 50, 0, 0);
    $self->{Output}->FillAttr(
     $main::BG_BLACK | $main::FG_GRAY, 80 * 50, 0, 0);
   #title  
    $self->{Output}->FillAttr(
     $main::BG_LIGHTBLUE | $main::FG_WHITE, 31, 25, 24);
   #base  
    $self->{Output}->FillAttr(
     $main::BG_BLUE | $main::FG_LIGHTCYAN, 1, 25, 25);
   #text  
    $self->{Output}->FillAttr(
     $main::BG_BLUE | $main::FG_WHITE, 30, 26, 25);
   #buttons  
    $self->{Output}->FillAttr(
     $main::BG_BLUE | $main::FG_LIGHTCYAN, 31, 25, 26);

    $self->{Output}->WriteChar('Goto Location...', 25, 24);
    $self->{Output}->WriteChar('.', 25, 25);
    $self->_UpdateButtons();
    $self->{Output}->Display();
}

sub _UpdateText {
    my($self) = @_;
    $self->{Output}->FillChar(' ', 30, 26, 25);
    if(length($self->{Txt}) > 30) {
        $self->{Output}->WriteChar(
         '...' . substr($self->{Txt}, length($self->{Txt}) - 30, 30), 26, 25);
    }else{
        $self->{Output}->WriteChar($self->{Txt}, 26, 25);
    }    
}

sub _UpdateButtons {
    my($self) = @_;
    my %states = (
        0 => 'From: [Start] Current Pos  End ',
        1 => 'From:  Start [Current Pos] End ',
        2 => 'From:  Start  Current Pos [End]'
    );
    $self->{Output}->WriteChar($states{$self->{ActiveButton}}, 25, 26);
}
1;


#       Goto Location________________
#       $fc000_______________________
#       From: Start  Current Pos  End
#       (14, 24)  30 x 3
#
#
#
#
