#!/usr/bin/perl
package Hex::MessageBox;
use strict;
use Win32::Console;

sub new {
    my($class, $title, $msg, @buttons) = @_;
    my $self = {
        Title => $title, 
        Msg   => $msg,
        Buttons => [@buttons],
        ButtonStr => join('  ', @buttons),
        ActiveButton => 0,
        Width => 0,
        Height => 0,
        In => $Hex::INPUT_CONSOLE,
        Out=> new Win32::Console,
        Handler => {
            13 => \&_kEnter,
            32 => \&_kSpaceBar,
            37 => \&_kLeft,
            39 => \&_kRight,            
        },    
    };
    bless($self, $class);
    return $self;
}

sub Run {
    my($self) = @_;
    $self->{In}->Cursor(0,0,0,0);    
    ($self->{Width}, $self->{Height}) = $self->_CalcSize();
    $self->_Draw();

    my $stop;
    while(1) {
        if($self->{In}->GetEvents()) {
            my @event = $self->{In}->Input();
            if($event[1] && defined $self->{Handler}->{$event[3]}) {
                $stop = $self->{Handler}->{$event[3]}->($self);
            }
            last if($stop);
        }
    }
    return $self->{ActiveButton};
}

sub _kEnter {
    my($self) = @_;
    return 1;
}
sub _kSpaceBar {
    my($self) = @_;
    return 1;
}
sub _kLeft {
    my($self) = @_;
    if($self->{ActiveButton} == 0) {
        $self->{ActiveButton} = $#{ $self->{Buttons} };
        $self->_DrawButtons;
    }else{
        $self->{ActiveButton}--;
        $self->_DrawButtons;
    }
    return 0;
}
sub _kRight {
    my($self) = @_;
    if($self->{ActiveButton} == $#{ $self->{Buttons} }) {
        $self->{ActiveButton} = 0;
        $self->_DrawButtons;
    }else{
        $self->{ActiveButton}++;
        $self->_DrawButtons;
    }
    return 0;    
}

sub _CalcSize {
    my($self) = @_;
    my $height = 3 + ($self->{Msg} =~ tr/\n//);
    my $width = 0;
    foreach(split(/\n/, $self->{Msg})) {
        $width = length($_) + 2 if(length($_) + 2 > $width);
    }
    $width = length($self->{Title}) if(length($self->{Title}) > $width);
   #create buttonwidth to avoid that calculation twice 
    my $buttonwidth = length(join('  ', @{ $self->{Buttons} })) + 1;
    $width = $buttonwidth if($buttonwidth > $width);
    
    return($width, $height);
}

sub _Draw {
    my($self) = @_;
    my $left = 40 - int($self->{Width} / 2);
    my $top = 25 - int($self->{Height} / 2);

    $self->{In}->Mode(ENABLE_PROCESSED_INPUT);
    $self->{Out}->Size(80, 50);
    $self->{Out}->Cursor(0, 0, 0, 0);
    $self->{Out}->FillAttr($main::BG_BLACK | $main::FG_GRAY, 80 * 50, 0, 0);
    $self->{Out}->FillChar(' ', 80 * 50, 0, 0);
   #Title 
    $self->{Out}->FillAttr($main::FG_WHITE | $main::BG_LIGHTBLUE, $self->{Width}, $left, $top);
    $self->{Out}->WriteChar($self->{Title}, $left, $top);
   #Message
    my $linenum = 1;
    foreach(split(/\n/, $self->{Msg})) {
        $self->{Out}->FillAttr($main::FG_WHITE | $main::BG_BLUE, $self->{Width}, $left, $top + $linenum);
        $self->{Out}->WriteChar($_, $left + 1, $top + $linenum);
        $linenum++;
    }
   #Buttons
    $self->_DrawButtons();
    $self->{Out}->Display();
}

sub _DrawButtons {
    my($self) = @_;
    my $left = 40 - int($self->{Width} / 2);
    my $top = 25 - int($self->{Height} / 2);

    $self->{Out}->FillAttr(
                  $main::FG_LIGHTCYAN | $main::BG_LIGHTBLUE, 
                  $self->{Width}, 
                  $left,
                  $top + 2 + ($self->{Msg} =~ tr/\n//));
    
    my $active = $self->{ActiveButton};
    my @buttons = @{ $self->{Buttons} };
    foreach(0..$#buttons) {
        unless($_ == $active) {
            $buttons[$_] = " $buttons[$_] ";
        }else{
            $buttons[$_] = "[$buttons[$_]]";
        }    
    }

    
    $self->{Out}->WriteChar(
                  sprintf('%*s', $self->{Width}, join('', @buttons)),
                  $left,
                  $top + 2 + ($self->{Msg} =~ tr/\n//));
}

1;
