/********************************************************************
 *                                                                  *
 * Hexecute -                                                       *
 *	Hex editor with table file and DTE support                       *
 * MDW2                                                             *
 * 07-09-1999                                                       *
 *                                                                  *
 * You are free to modify and distribute it, so long as you do not  *
 * attempt to make any profit whatsoever from it.                   *
 *																	 		   		  *
 *																	                 *
 ********************************************************************/

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <io.h>
#include <stdlib.h>
#include <dos.h>
#include "character.h"
#include "vale.h"

/* [CUSTOM DATA TYPES] */

typedef unsigned char BYTE_TYPE;
typedef unsigned short WORD;
typedef short widechar;

typedef struct search_struct{
	   BYTE_TYPE byte[0x1000];
	   } search_struct;

typedef struct byte_struct{
	   BYTE_TYPE byte[0x2a0];
	   } byte_struct;

typedef struct table_data{
	   BYTE_TYPE value[1000];
	   BYTE_TYPE characters[1000][10];
	   } table_data;

typedef struct ResultStruct{
        unsigned long Address;
        unsigned char * Data;
        ResultStruct* Next;
        ResultStruct* Prev;
        } ResultStruct;

typedef struct ChangeStruct{
		unsigned long Address;
      unsigned char * Data;
      } ChangeStruct;

int NumChanges = 0;
int LongestChange = 0;
int NumResults = 0;
ResultStruct* Results[250];
ChangeStruct* Changes[100];

/* [MACROS] */

#define help_data() cout << "Hexecute - Copyright 1999 Mike Walston" << endl \
						  << "V. 1.2 - a hex editor with DTE support" << endl \
						  << endl \
						  << "hexecute <optional>romname.ext <optional>table.tbl" << endl \
						  << "[Usage instructions]" << endl \
						  << "Up    = Moves the cursor up one row" << endl \
						  << "Down  = Moves the cursor down one row" << endl \
						  << "Left  = Moves the cursor back one character" << endl \
						  << "Right = Moves the cursor forward one character" << endl \
						  << "PageUp= Moves the cursor up in the rom 256 bytes" << endl \
						  << "PageDn= Moves the cursor down in the rom 256 bytes" << endl \
						  << "End   = Moves the cursor to the end of the rom" << endl \
						  << "Home  = Moves the cursor to the beginning of the rom" << endl\
						  << "Tab   = Switches between table file and ascii mode" << endl \
						  << "F1    = Jumps to a desired offset (decimal or hex)" << endl\
						  << "F2    = Inserts a text string at current location" << endl\
						  << "F3    = Inserts a hex value at the current location" << endl\
						  << "F4    = Brings up the rom expansion screen" << endl\
						  << "F5    = Brings up the script dumper " << endl \
						  << "F6    = Relative Searching Function" << endl \
						  << "F7    = Value Searching Function" << endl \
						  << "F8    = Script insertion from file" << endl \
						  << "esc   = end the program" << endl\
                    << "Allo mon coco" << endl;\
					  return 0;



#define end_data() textcolor(15); \
                                        cprintf("\r\nHexecute - Copyright 1999 Mike Walston\r\n"); \
					cprintf("\r\nV 1.2 - a hex editor with DTE support, ROM expansion,\r\n"); \
					cprintf("        relative searching, value searching, script\r\n"); \
					cprintf("        dumping, ascii or table file dependant text\r\n"); \
					cprintf("        insertion (by hand or from a file), and \r\n"); \
					cprintf("        default ascii mode.\r\n\n"); \
					cprintf("        Much thanks to Animefx for being a great beta tester\r\n"); \
               cprintf("        and to Jair for sharing his nes graphics code\r\n\n"); \
					cprintf("[USAGE]: hexecute <optional>romname.ext <optional>table.tbl\r\n"); \
					cprintf("[note]: typing \"hexecute help\" at the prompt will make a help screen appear\r\n"); \
               cprintf("Allo mon coco\r\n"); \
					return 0;

#define line() textcolor(15); textbackground(3); \
			   cprintf("                                                                              \r\n"); \
			   textbackground(0);

#define line_up(x) textcolor(15); textbackground(3); \
				  cprintf(" "); textbackground(0); textcolor(x);

#define too_small(x) printf("\n You must expand the rom to a file size more than %dMb. \r\n\n", x);


/* [DEFINED CONSTANTS] */

#define NO 0
#define YES 1
#define UP 10001
#define DOWN 10002
#define LEFT 10003
#define RIGHT 10004
#define HEX_FOCUS 40001
#define CHAR_FOCUS 40002

/* [FUNCTIONS] */
void StrTerminate(char* character)
	{
   character = 0;
   }

BYTE_TYPE *strcatchar(BYTE_TYPE *s, BYTE_TYPE c)
	{
	BYTE_TYPE ss[2];
	ss[0]=c;
	ss[1]=0;
	return strcat(s,ss);
	}

BYTE_TYPE *strcpychar(BYTE_TYPE *s, BYTE_TYPE c)
	{
	BYTE_TYPE ss[2];
	ss[0]=c;
	ss[1]=0;
	return strcpy(s,ss);
	}

int hex_lower(unsigned int value, unsigned int convert_sub)
	{
	return((value - convert_sub));
	}

int hex_upper(unsigned int value, unsigned int convert_sub)
	{
	return((value - convert_sub) << 4);
	}

unsigned char ReturnHex(unsigned char * temp, int firstNum)
	{
   unsigned char temp_val;
   unsigned char high_temp;
   unsigned char low_temp;
   if(temp[firstNum] >= 'a' && temp[firstNum] <= 'f')
   	{ high_temp = hex_upper(temp[firstNum], 0x57); }
   else if(temp[firstNum] >= '0' && temp[firstNum] <= '9')
   	{ high_temp = hex_upper(temp[firstNum], 0x30); }
   else if(temp[firstNum] >= 'A' && temp[firstNum] <= 'F')
   	{ high_temp = hex_upper(temp[firstNum], 0x37); }
   if(temp[firstNum + 1] >= 'a' && temp[firstNum + 1] <= 'f')
   	{ low_temp = hex_lower(temp[firstNum + 1], 0x57); }
   else if(temp[firstNum + 1] >= '0' && temp[firstNum + 1] <= '9')
   	{ low_temp = hex_lower(temp[firstNum + 1], 0x30); }
   else if(temp[firstNum + 1] >= 'A' && temp[firstNum + 1] <= 'F')
   	{ low_temp = hex_lower(temp[firstNum + 1], 0x37); }
   temp_val = high_temp + low_temp;
   return temp_val;
	}

void ReadTable(table_data &FirstTable, int &counter, fstream &TableFile)
	{
   counter = 0;
   unsigned int tmpCtr;
   unsigned int ValTemp;
   unsigned char SwapTemp[25];
   unsigned char temp[100];
	TableFile.getline(temp, 100);
	while( !TableFile.eof() )
   	{
	   switch (temp[0])
      	{
         case '[':
         case '(':
      	case '$': TableFile.getline(temp, 100);
         			 break;
         case '/': FirstTable.characters[counter][0] = '/';
         			 StrTerminate(reinterpret_cast<char *> ( &FirstTable.characters[counter][1]) );
                   FirstTable.value[counter] = ReturnHex(temp, 1);
						 TableFile.getline(temp, 100);
                   counter++;
                   break;
         case '*': FirstTable.characters[counter][0] = '*';
         			 StrTerminate(reinterpret_cast<char *> ( &FirstTable.characters[counter][1]) );
                   FirstTable.value[counter] = ReturnHex(temp, 1);
						 TableFile.getline(temp, 100);
                   counter++;
                   break;
         default:  FirstTable.value[counter] = ReturnHex(temp, 0);
                   for(tmpCtr = 3; tmpCtr < strlen(reinterpret_cast<char *>( temp )); tmpCtr++)
                   	{
                     if(tmpCtr == 3) strcpychar(&FirstTable.characters[counter][tmpCtr - 3], temp[tmpCtr]);
                     else strcatchar(&FirstTable.characters[counter][tmpCtr - 3], temp[tmpCtr]);
                     }
						 StrTerminate((char *) &FirstTable.characters[counter][tmpCtr] );
         			 TableFile.getline(temp, 100);
                   counter++;
                   break;
         }
     	}
	for(int a = 0; a < counter; a++)
   	{
      for(int b = 0; b < counter - 1; b++)
      	{
         if(strlen(FirstTable.characters[b]) < strlen(FirstTable.characters[b + 1]) )
         	{
            strcpy(SwapTemp, FirstTable.characters[b]);
            strcpy(FirstTable.characters[b], FirstTable.characters[b + 1]);
				strcpy(FirstTable.characters[b + 1], SwapTemp);
            ValTemp = FirstTable.value[b];
            FirstTable.value[b] = FirstTable.value[b + 1];
            FirstTable.value[b + 1] = ValTemp;
            }
         }
      }
   }

void rom_expand(int x, FILE *romfile)
	 {
	 BYTE_TYPE a[0x200];
	 for(int q = 0; q < 0x200; q++)
		 a[q] = 0x00;
	 fseek(romfile,0,SEEK_END);
	 long e = ftell(romfile);
	 long d = (0x20000 * x) + 0x200;
	 cprintf("\r\nExpanding ROM.\r\n");
	 while(e < d)
	   {
	   fwrite(&a,sizeof(a),1,romfile);
	   e = ftell(romfile);
	   }
	 clrscr();
	 cprintf("Done!  You now have a %dMb ROM\r\npress any key.",x);
	 getch();
	 }

void newscreen()
	   {
	   clrscr();

	   /* Main Title Bar */
	   window(1,1,80,3);
			textbackground(3);
			cprintf(" F1. Jump   F2. Text Ins.  F3. Hex Ins.  F4. Expand ROM  F5. Dump Script       ");cprintf("\r\n");
			line_up(15);
			textcolor(9); textbackground(0);
			cprintf("                           - Hexecute - by MDW2 -                            ");
			line_up(7);
			printf("\r\n");
			textbackground(3); textcolor(15);
			cprintf(" Address    0 1 2 3 4 5 6 7 8 9 A B C D E F           Characters               ");

	   /* Left Border Bar */
	   window(1,4,1,50);
			textbackground(3);
			for(int g = 4; g <= 50; g++)
				{
				cprintf(" ");
				}

	   /* Bar between Hex and characters */
	   window(44,4,44,46);
			textbackground(3);
			for(int r = 4; r <= 46; r++)
				{
				cprintf(" ");
				}

	   /* Bar on Right Edge */
	   window(79,4,79,50);
			textbackground(3);
			for(int p = 4; p <= 50; p++)
				cprintf(" ");

	   /* horizontal Bar above byte data*/
	   window(1,46,80,46);
			textbackground(3);
			insline();

	   /* Bottom Bar */
	   window(1,50,80,50);
			textbackground(3);
			cprintf(" F6. Searches  F7. Graphic Uti.  F8. Insert Script  ESC. quit                  ");

	   /* ERROR CORRECTION */
	   window(80,50,80,50);
			textbackground(0);
			cprintf(" ");
	   window(80,46,80,46);
			textbackground(0);
			cprintf(" ");
	   window(80,50,80,50);
			textbackground(0);
			cprintf(" ");
	   }

void data_output(byte_struct area,
				 unsigned long int address,
				 int xpos,
				 int ypos,
				 int table_exists,
				 int count,
				 table_data table
				 )
	{
	for(int a = 0;a < NumChanges; a++)
   	{
      for(int b = 0 - LongestChange; b < 0x2a0; b++)
      	{
         if(Changes[a]->Address == address + b)
         	{
				for(int c = 0; c < strlen(Changes[a]->Data); c++)
               if( ( b + c ) >= 0 )
						area.byte[b + c] = Changes[a]->Data[c];
            break;
            }
         }
      }



	 int tablecounter = 0;

	 /*removes cursor*/
	 _setcursortype(_NOCURSOR);

	 /*removes trash from last screen, should help reduce blinking */
	 window(61,4,78,45);
		textbackground(0);
		clrscr();

	 /* character output */
	 window(45,4,78,49);
		textbackground(0);
		if(table_exists == NO) // ascii character output routine
		{
		for(int q = 0;q < 0x2a0;q++)
			{
			textbackground(0);
			textcolor(10);
			if((q+1) == (xpos + ((ypos - 1) * 16)))
				{
				textbackground(10);
				if(area.byte[q] < 0x20)
				   cprintf(" ");
				else
				   putch(area.byte[q]);
				if(!((q + 1) % 16) && (q != 0x29f))
					cprintf("\r\n");
				}
			else
				{
				if(area.byte[q] < 0x20)
				   cprintf(" ");
				else
				   putch(area.byte[q]);
				if(!((q + 1) % 16) && (q != 0x29f))
					{
					cprintf("\r\n");
					}
				}
			}
		}
		if(table_exists == YES) // table file output routine
		{
		for(int d = 0; d < 0x2a0; d++)
			{
			textbackground(0);
			textcolor(15);
			if((d+1) == (xpos + ((ypos - 1) * 16)))
				{
				textbackground(10);
				tablecounter = 0;
				while(area.byte[d] != table.value[tablecounter] &&
					  tablecounter < count)
					  {
					  tablecounter++;
					  }
				if(tablecounter == count)
					cprintf("#");
				else if(table.characters[tablecounter][0] == '*')
					 {
					 textcolor(12);
					 cprintf("%s", table.characters[tablecounter]);
					 }
				else if(table.characters[tablecounter][0] == '/')
					 {
					 textcolor(10);
					 cprintf("%s", table.characters[tablecounter]);
					 }
				else cprintf("%s", table.characters[tablecounter]);
				if(!((d + 1) % 16) && (d != 0x29f))
				   cprintf("\r\n");
				}
			else
				{
				tablecounter = 0;
				while(area.byte[d] != table.value[tablecounter] &&
					  tablecounter < count)
					  {
					  tablecounter++;
					  }
				if(tablecounter == count)
					cprintf("#");
				else if(table.characters[tablecounter][0] == '*')
					 {
					 textcolor(12);
					 cprintf("%s", table.characters[tablecounter]);
					 }
				else if(table.characters[tablecounter][0] == '/')
					 {
					 textcolor(10);
					 cprintf("%s", table.characters[tablecounter]);
					 }
				else cprintf("%s", table.characters[tablecounter]);
				if(!((d + 1) % 16) && (d != 0x29f))
				   cprintf("\r\n");
				}
			}
		}

	/* address box */
	window(1,4,11,46);
		for(int z = 0;z < 0x2a;z++)
			{
			line_up(9);
			textcolor(15);
			cprintf("$");
			textcolor(9);
			cprintf("%08lX", address + (16 * z));
			line_up(9);
			}

	/* message box  */
	window(2,47,78,49);
		{
		clrscr();
		textbackground(0);
		textcolor(15);
		cprintf("address: %08lX\r\n", (address + (xpos - 1) + ((ypos - 1) * 16)));
		cprintf("value: %02X", area.byte[(xpos - 1) + ((ypos - 1) * 16)]);
		if(area.byte[(xpos - 1) + ((ypos - 1) * 16)] > 0x20)
		   cprintf("  ascii: %c", area.byte[(xpos - 1) + ((ypos - 1) * 16)]);
		}
	/* hex data box */
	window(12,4,43,46);
		{
		int v = 1;
		for(int k = 0; k < 0x2a0; k++)
			{
			textbackground(0);
			textcolor(11);
			if((k+1) == (xpos + ((ypos - 1) * 16)))
				{
				textbackground(10);
				cprintf("%02X", area.byte[k]);
				}
			else
				cprintf("%02X", area.byte[k]);
			if(!((k + 1) % 16) && (k != 0))
				{
				v++;
				gotoxy(1,v);
				}
			}
		gotoxy(2,1);
		}
	textbackground(0);
	}

void screen_refresh(byte_struct &area,
					unsigned long int address,
					FILE *romfile,
					int xposition,
					int yposition,
					char tablechoice,
					int count,
					table_data table
					)
	 {
	 fseek(romfile,address,SEEK_SET);
	 fread(&area,sizeof(byte_struct),1,romfile);
	 data_output(area,address,xposition,yposition,tablechoice,count,table);
	 }

int getkey(void)
   {
	union REGS in, out;
   in.h.ah = 0x08;
   int86(0x21, &in, &out);
   if (out.h.al == 0)
	  {
	  return(getkey()+0x100);
	  }
   else
	  {
	  return(out.h.al);
	  }
	}

void GraphicsRoutines()
	{
   int GraphicsChoice;
   window(2,4,78,49);
   clrscr();
   _setcursortype(_NORMALCURSOR);
   cprintf("What would you like to do? \r\n\n");
   cprintf("A. Extract NES graphics to bmp?\r\n");
   cprintf("B. Insert NES graphics from bmp?\r\n");
	GraphicsChoice = getkey();
   switch(toupper(GraphicsChoice)) {
   	case 'A':GraphicExtract(); break;
      case 'B':GraphicInsert(); break;
      default:break; };
   _setcursortype(_NOCURSOR);
   }

void script_dump(table_data table, FILE* romfile, int count)
	{

	unsigned long int start_dump;
	unsigned long int stop_dump;
	unsigned long int current_address;

	int lettercounter;
	int keypress;

	window(2,47,78,49);
	clrscr();
	byte_struct script_data;

	FILE* dump;

	char dump_name[20];
	char start_string[25];
	char end_string[25];
	char* start_pointer;
	char* end_pointer;
	char* ptr;
	char* nptr;

	_setcursortype(_NORMALCURSOR);
	cprintf("File name for script dump\r\n=> ");
	scanf("%s", dump_name);
	dump = fopen(dump_name, "w");
	clrscr();

	cprintf("Please enter the starting address for the dump\r\n=> ");
	scanf("%s", start_string);
	start_pointer = start_string;
	start_dump = strtoul(start_pointer, &ptr, 16);
	clrscr();

	current_address = start_dump;

	cprintf("Please enter the ending address for the dump\r\n=> ");
	scanf("%s", end_string);
	end_pointer = end_string;
	stop_dump = strtoul(end_pointer, &nptr, 16);
	clrscr();

	cprintf("Dumping Script...\r\n\n");

	fseek(romfile, start_dump, SEEK_SET);
	fread(&script_data, sizeof(byte_struct), 1, romfile);
	current_address = start_dump;
	while(current_address < stop_dump)
		{
		for(int j = 0; j < 256; j++)
			{
			lettercounter = 0;
			while(script_data.byte[j] != table.value[lettercounter] &&
				  lettercounter < count)
				  {
				  lettercounter++;
				  }
			if(lettercounter == count)
				  fprintf(dump,"<$%02x>", script_data.byte[j]);
			else if(table.characters[lettercounter][0] == '/')
				  fprintf(dump,"\n\n");
			else if(table.characters[lettercounter][0] == '*')
				  fprintf(dump, "\n");
			else fprintf(dump,"%s", table.characters[lettercounter]);
			}
		current_address += 0x100;
		fseek(romfile, current_address, SEEK_SET);
		fread(&script_data, sizeof(byte_struct), 1, romfile);
		}
	cprintf("done! Press ESC to go back to editing.");
	keypress = getkey();
	while(keypress != 0x1b)
		keypress = getkey();
	fclose(dump);
	}

unsigned long RelativeSearch(FILE *romfile, unsigned long int MAX_ADDRESS)
{

// initialization of data variables
search_struct SearchData;

NumResults = 0;

int DumpCounter;
int DeletingThings;
int KeyboardInput;
int DrawCounter;
int NumWildCards = 0;
int TableLayout = 1;
int SomethingFound = 0;
int SearchCounter = 0;
int CharacterCounter = 0;
int CompareValues[104];
int DisplayCounter = 0;
int HighestDisplayed;
int LowestDisplayed;
int CurrentHighlighted;

unsigned long StartAddress = 0;
unsigned long EndAddress = MAX_ADDRESS - 0x2a0;
unsigned long CurrentAddress;
unsigned long ReturnAddress;

char *DblPtr;                      // for use in strtoul(), i'm not sure why it needs it, but it does
char DumpName[25];
char TempHolder[10];
char InputString[100];

FILE* DumpFile;

//draw little info line at the top of the screen
window(2,3,78,3);
textbackground(3); textcolor(15);
cprintf(" Address                                                                    ");
textbackground(0);

// initializing the search data
for(int a = 0; a < 0x1000; a++)
	SearchData.byte[a] = 0;

// initializing window for use in this routine
window(2,2,78,49);    // grab the whole screen with the exception of the borders
clrscr();				// clear it all
_setcursortype(_NORMALCURSOR);

// input routines for necessary data
cprintf("input the starting address: ");
cin.getline(InputString, 104, '\n');
cprintf("\r\n");

// if Inputstring is 'start' or 'beginning' then the search will start at address 0
// else it will start at the address input by the user
if( !strcmpi(InputString, "start") || !strcmpi(InputString, "beginning") )
	StartAddress = 0;
else StartAddress = strtoul(InputString, &DblPtr, 16);

cprintf("input ending address: ");
cin.getline(InputString, 104, '\n');
cprintf("\r\n");

//if Inputstring is 'end' or 'finish' then the search will stop at the end of
//the rom, else it will stop at the address input by the user
if( !strcmpi(InputString, "end") || ! strcmpi(InputString, "finish") )
	EndAddress = MAX_ADDRESS + 0x2a0;
//	EndAddress = MAX_ADDRESS - 0x2a0;
else EndAddress = strtoul(InputString, &DblPtr, 16);

cprintf("input the search string : ");
cin.getline(InputString, 104, '\n');
cprintf("\r\n");
cprintf("input the font table layout\r\n");
cprintf("1. Caps-low-num <default>  2. low-caps-num\r\n");
cprintf("3. num-caps-low            4. num-low-caps\r\n");
cin >> TableLayout;
cin.ignore(10, '\n');

// loop while incorrect data is input
while(TableLayout != 1 && TableLayout != 2 &&
      TableLayout != 3 && TableLayout != 4 )
	{
   cprintf("Please enter the correct value = ");
   cin >> TableLayout;
	cin.ignore(10, '\n');
	}

//depending on with font table layout the user chose, this will initialize the integer
//array 'CompareValues' to the proper values
switch(TableLayout)
{
	case(1):CharDeterminer1( InputString, CompareValues, strlen(InputString) ); break;
   case(2):CharDeterminer2( InputString, CompareValues, strlen(InputString) ); break;
   case(3):CharDeterminer3( InputString, CompareValues, strlen(InputString) ); break;
   case(4):CharDeterminer4( InputString, CompareValues, strlen(InputString) ); break;
   default:return 0; } ;

// set the file pointer to the file and read the search data into the struct
fseek(romfile, StartAddress, SEEK_SET);
fread(&SearchData, 1, sizeof(search_struct), romfile);
CurrentAddress = StartAddress;
while( ( CurrentAddress < EndAddress ) && ( NumResults < 250 ) )
	{
   for(SearchCounter = 0; SearchCounter < 0x1000 - strlen(InputString); SearchCounter++)
		{
	   for(CharacterCounter = 0; CharacterCounter < strlen(InputString); CharacterCounter++)
   		{
         NumWildCards = 0;     // there aren't any current wildcards in use
         while( ( CompareValues[CharacterCounter] == 0x9999 ) &&
                ( CharacterCounter < strlen(InputString) -1 ) )
         	{
            CharacterCounter++;
            }
         // while the current character being processed is a wildcard (space or asterisk) the counter
         // increments and simply doens't do any calculations involving that character
      	while( ( CompareValues[CharacterCounter + 1 + NumWildCards] == 0x9999 ) &&
                ( CharacterCounter < strlen(InputString) - 1) )
            {
         	NumWildCards++;			// while the input string has a '*" or a ' ' the program will merely
            }
         if( ( CompareValues[CharacterCounter] - CompareValues[CharacterCounter + NumWildCards + 1] ) !=
         	 ( SearchData.byte[SearchCounter + CharacterCounter] - SearchData.byte[SearchCounter + CharacterCounter + NumWildCards + 1] ) )
             break;  	// if the program finds a difference in the data from the search string, it will break out of the for loop
             				// signalling that it did not find a match
			}
		if( CharacterCounter + 1 == strlen(InputString) )
      	{
            Results[NumResults] = new ResultStruct;      // declare a new ResultStruct object for the current pointer
            Results[NumResults]->Address = CurrentAddress + SearchCounter;
            Results[NumResults]->Data = new char[100]; //declare memory for the string to be stored in Data
			   sprintf(Results[NumResults]->Data, "Search -> %s || Hex -> ", InputString);
            for(int HolderCounter = 0; HolderCounter < strlen(InputString); HolderCounter++)
            	{
						sprintf(TempHolder, "%02X ", SearchData.byte[SearchCounter + HolderCounter]);
               	strcat(Results[NumResults]->Data, TempHolder);
               }
            strcat(Results[NumResults]->Data, "\r\n");
            NumResults++; // Increment the results counter
			}
      }
   //increment file counter to the size of a SearchStruct minus the length of the
   //search string because we don't want to miss results that would overlap between
   //two search structs
	CurrentAddress += 0x1000 - strlen(InputString);
   fseek(romfile, CurrentAddress, SEEK_SET);
   fread(&SearchData, 1, sizeof(search_struct), romfile);
   }
clrscr();
if(NumResults == 0) // exit the function if nothing was found
	return 0;
// routine to handle keyboard events after finding search data
LowestDisplayed = CurrentHighlighted = 0;
HighestDisplayed = ( ( NumResults < 44 ) ? NumResults : 44 );

// draw new info bar on the top of the screen
window(2,3,78,3);
textbackground(3);
cprintf("#### Address -----------------------------Data----------------------------- ");
textbackground(0);

// fix my goof up on that bar that makes "address" disappear if it goes one more space
window(78,3,78,3);
textbackground(3);
cprintf(" ");
textbackground(0);

// draw info window for the first time
window(2,4,78,49);
clrscr();
textcolor(15);
for(DrawCounter = 0; DrawCounter < NumResults; DrawCounter++)
	{
   textbackground(0);
   if( ( DrawCounter < LowestDisplayed ) || ( DrawCounter > HighestDisplayed ) )
   	;
   else { if( DrawCounter == CurrentHighlighted )
   	textbackground(1);
      cprintf("%04i %08lX ",DrawCounter + 1, Results[DrawCounter]->Address);
      cprintf("%62s", Results[DrawCounter]->Data);
      textbackground(0); }
   }

// loop until user exits function by selecting escape to go back to editing or
// by hitting enter and jumping to the selected address
_setcursortype(_NOCURSOR);
for(;;)
	{
   KeyboardInput = getkey();      // gets keyboard input on keypress
   switch(KeyboardInput)
   	{
      case 0x148:	// up
                 if(CurrentHighlighted == 0) // if it's already at the highest one
                 		break;
					  else if(CurrentHighlighted == LowestDisplayed) // if it's at the highest one currently onscreen
                     {														 // but not the highest one in the array
                 		CurrentHighlighted--;
                     LowestDisplayed--;
							HighestDisplayed--;

                     window(2,4,78,49);
							   textcolor(15);

							   for(DrawCounter = 0; DrawCounter < NumResults; DrawCounter++)
						   	{
                           textbackground(0);
							      if( ( DrawCounter < LowestDisplayed ) || ( DrawCounter > HighestDisplayed ) )
							      	;
									else { if( DrawCounter == CurrentHighlighted )
                                  	textbackground(1);
            							 cprintf("%04i %08lX ",DrawCounter + 1, Results[DrawCounter]->Address);
                           		 cprintf("%62s", Results[DrawCounter]->Data);
                                  textbackground(0); }
						      }
							}
                 else   // if it somewhere in the middle
                 		{
                     CurrentHighlighted--;
							window(2,4,78,49);
							   textcolor(15);
							   for(DrawCounter = 0; DrawCounter < NumResults; DrawCounter++)
						   	{
                           textbackground(0);
							      if( ( DrawCounter < LowestDisplayed ) || ( DrawCounter > HighestDisplayed ) )
							      	;
									else { if( DrawCounter == CurrentHighlighted )
                                  	textbackground(1);
            							 cprintf("%04i %08lX ",DrawCounter + 1, Results[DrawCounter]->Address);
                           		 cprintf("%62s", Results[DrawCounter]->Data);
                                  textbackground(0); }
						      }
                     }
      			  break;
      case 0x150: // down
                 if(CurrentHighlighted == NumResults - 1)
      				   break;
      			  else if(CurrentHighlighted == HighestDisplayed)
                 		{
                     CurrentHighlighted++;
                     LowestDisplayed++;
                     HighestDisplayed++;
                     window(2,4,78,49);
							   textcolor(15);

							   for(DrawCounter = 0; DrawCounter < NumResults; DrawCounter++)
						   	{
									textbackground(0);
							      if( ( DrawCounter < LowestDisplayed ) || ( DrawCounter > HighestDisplayed ) )
							      	;
									else { if( DrawCounter == CurrentHighlighted )
                                  	textbackground(1);
            							 cprintf("%04i %08lX ",DrawCounter + 1, Results[DrawCounter]->Address);
                           		 cprintf("%62s", Results[DrawCounter]->Data);
                                  textbackground(0); }
						      }
                     }
                 else
                 		{
                     CurrentHighlighted++;
							window(2,4,78,49);
							   textcolor(15);
							   for(DrawCounter = 0; DrawCounter < NumResults; DrawCounter++)
						   	{
                           textbackground(0);
							      if( ( DrawCounter < LowestDisplayed ) || ( DrawCounter > HighestDisplayed ) )
							      	;
									else { if( DrawCounter == CurrentHighlighted )
                                  	textbackground(1);
            							 cprintf("%04i %08lX ",DrawCounter + 1, Results[DrawCounter]->Address);
                           		 cprintf("%62s" ,Results[DrawCounter]->Data);
                                  textbackground(0); }
						      }
                     }
                 break;
      case 0x0d: // enter
					  ReturnAddress = Results[CurrentHighlighted]->Address;
                 for(DeletingThings = 0; DeletingThings < NumResults; DeletingThings++)
                 	{
                  delete(Results[DeletingThings]->Data);
						delete(Results[DeletingThings]);
                  }
                 NumResults = 0;
					  return ReturnAddress;
      case 0x1b: // escape
      			  for(DeletingThings = 0; DeletingThings < NumResults; DeletingThings++)
                 	{
                  delete(Results[DeletingThings]->Data);
						delete(Results[DeletingThings]);
                  }
                 NumResults = 0;
                 return 0;
      case 0x20: window(2,4,78,49);
      			  clrscr();
                 cprintf("Please enter the file name for the search dump\r\n");
                 cin.getline(DumpName, 25, '\n');
                 DumpFile = fopen(DumpName, "w");
                 for(DumpCounter = 0; DumpCounter < NumResults; DumpCounter++)
                 		fprintf(DumpFile, "%04i %08lX %62s", DumpCounter + 1, Results[DumpCounter]->Address, Results[DumpCounter]->Data);
      			  for(DeletingThings = 0; DeletingThings < NumResults; DeletingThings++)
                 	{
                  delete(Results[DeletingThings]->Data);
						delete(Results[DeletingThings]);
                  }
                 NumResults = 0;
                 return 0;
      default:break;
      }
   }
}

unsigned long HexValueSearch(FILE *romfile, unsigned long int MAX_ADDRESS)
{
search_struct SearchData;
NumResults = 0;

//characters & character pointers
char* DblPtr;
char TempHolder[10];
char DumpName[25];
unsigned char  InputString[100];
unsigned char  InputChar;
unsigned char  SearchValues[50];

//unsigned longs
unsigned long StartAddress   = 0;
unsigned long EndAddress     = 0;
unsigned long CurrentAddress = 0;
unsigned long ReturnAddress  = 0;

// ints
int KeyboardInput         ;
int CurrentInputNumber = 0;
int PlaceInLine        = 1;
int NumberOfHex        = 0;
int ValueCounter       = 0;
int DrawCounter           ;
int HighestDisplayed      ;
int LowestDisplayed       ;
int CurrentHighlighted    ;
int HexCounter         = 0;
int DeletingThings     = 0;
int DumpCounter        = 0;
int LastWildCard       = NO;
int CounterMirror      = 0;

// File pointers
FILE* DumpFile;

//draw little info line at the top of the screen
window(2,3,78,3);
textbackground(3); textcolor(15);
cprintf(" Address                                                                    ");
textbackground(0);

// initializing the search data
for(int a = 0; a < 0x1000; a++)
	SearchData.byte[a] = 0;

// initializing window for use in this routine
window(2,2,78,49);    // grab the whole screen with the exception of the borders
clrscr();				// clear it all
_setcursortype(_NORMALCURSOR);

// input routines for necessary data
cprintf("input the starting address: ");
cin.getline(InputString, 104, '\n');
cprintf("\r\n");

// if Inputstring is 'start' or 'beginning' then the search will start at address 0
// else it will start at the address input by the user
if( !strcmpi(InputString, "start") || !strcmpi(InputString, "beginning") )
	StartAddress = 0;
else StartAddress = strtoul(InputString, &DblPtr, 16);

cprintf("input ending address: ");
cin.getline(InputString, 104, '\n');
cprintf("\r\n");

//if Inputstring is 'end' or 'finish' then the search will stop at the end of
//the rom, else it will stop at the address input by the user
if( !strcmpi(InputString, "end") || ! strcmpi(InputString, "finish") )
	EndAddress = MAX_ADDRESS + 0x2a0;
else EndAddress = strtoul(InputString, &DblPtr, 16);

// starting the input
cprintf("input the search string : \r\n");

InputChar = getkey();
while(InputChar != 0x0d)
	{
	switch(InputChar) {
      case '0':
	   case '1':
   	case '2':
	   case '3':
   	case '4':
	   case '5':
   	case '6':
	   case '7':
   	case '8':
	   case '9':
   	case 'a':
	   case 'b':
   	case 'c':
	   case 'd':
   	case 'e':
	   case 'f':
   	case 'A':
	   case 'B':
   	case 'C':
	   case 'D':
   	case 'E':
	   case 'F':
      case '*':
               if( CurrentInputNumber == 0 )
						{
                  	strcpychar(InputString, InputChar);
                     CurrentInputNumber++;
                     gotoxy(PlaceInLine,7);
                     cprintf("%c", InputChar);
                  }
               else
                  {
                     if(InputChar == '*')
                     	{
                        strcatchar(InputString, InputChar);
                        PlaceInLine += 2;
                        CurrentInputNumber += 2;
                        }
                     else {
                     	strcatchar(InputString, InputChar);
	                     if( ! ( CurrentInputNumber % 2 ) || ( LastWildCard ) )
   	                  	PlaceInLine += 2;
			               else PlaceInLine++;
         	            CurrentInputNumber++;}
                     gotoxy(PlaceInLine,7);
                     cprintf("%c", InputChar);
                  }

   	default: break; }
   if(CurrentInputNumber != 20)
   	InputChar = getkey();
   else
   	InputChar = 0x0d;
   }

for(NumberOfHex = 0; NumberOfHex < CurrentInputNumber / 2; NumberOfHex++)
	{
   if(InputString[HexCounter] == '*')
   	{
		SearchValues[NumberOfHex] = InputString[HexCounter];
      HexCounter++;
      }
	else
   	{
      SearchValues[NumberOfHex] = ReturnHex(InputString, HexCounter);
   	HexCounter += 2;
      }
   }



fseek(romfile, StartAddress, SEEK_SET);
fread(&SearchData, 1, sizeof(search_struct), romfile);
CurrentAddress = StartAddress;
while( ( CurrentAddress < EndAddress ) && ( NumResults < 250 ) )
   {
    for(int SearchCounter = 0; SearchCounter < 0x1000; SearchCounter++)
    	{
		for(ValueCounter = 0; ValueCounter < NumberOfHex; ValueCounter++)
			{
         if( SearchValues[ValueCounter] == '*' )
         	ValueCounter++;
		   if( SearchData.byte[SearchCounter + ValueCounter] != SearchValues[ValueCounter] )
         	break;
		   }
      if( ValueCounter == NumberOfHex )
      	{
            Results[NumResults] = new ResultStruct;      // declare a new ResultStruct object for the current pointer
            Results[NumResults]->Address = CurrentAddress + SearchCounter;
            Results[NumResults]->Data = new char[100]; //declare memory for the string to be stored in Data
			   for(int HolderCounter = -2; HolderCounter < NumberOfHex + 2; HolderCounter++)
            	{
               	sprintf(TempHolder, "%02X ", SearchData.byte[SearchCounter + HolderCounter]);
                  if(HolderCounter == -2)
                  	strcpy(Results[NumResults]->Data, TempHolder);
                  else if(HolderCounter == 0)
                     {
							strcat(Results[NumResults]->Data, "|| ");
                     strcat(Results[NumResults]->Data, TempHolder);
                     }
                  else if(HolderCounter == NumberOfHex)
                  	{
                     strcat(Results[NumResults]->Data, "|| ");
                     strcat(Results[NumResults]->Data, TempHolder);
                     }
						else
               		strcat(Results[NumResults]->Data, TempHolder);
               }
            strcat(Results[NumResults]->Data, "\r\n");
            NumResults++; // Increment the results counter
			}
      }
   CurrentAddress += 0x1000 - NumberOfHex;
   fseek(romfile, CurrentAddress, SEEK_SET);
   fread(&SearchData, 1, sizeof(search_struct), romfile);
   }

clrscr();
if(NumResults == 0) // exit the function if nothing was found
   return 0;

// routine to handle keyboard events after finding search data
LowestDisplayed = CurrentHighlighted = 0;
HighestDisplayed = ( ( NumResults < 44 ) ? NumResults : 44 );

// draw new info bar on the top of the screen
window(2,3,78,3);
textbackground(3);
cprintf("#### Address -----------------------------Data----------------------------- ");
textbackground(0);

// fix my goof up on that bar that makes "address" disappear if it goes one more space
window(78,3,78,3);
textbackground(3);
cprintf(" ");
textbackground(0);

// draw info window for the first time
window(2,4,78,49);
clrscr();
textcolor(15);
for(DrawCounter = 0; DrawCounter < NumResults; DrawCounter++)
	{
   textbackground(0);
   if( ( DrawCounter < LowestDisplayed ) || ( DrawCounter > HighestDisplayed ) )
   	;
   else { if( DrawCounter == CurrentHighlighted )
   	textbackground(1);
      cprintf("%04i %08lX ",DrawCounter + 1, Results[DrawCounter]->Address);
      cprintf("%62s", Results[DrawCounter]->Data);
      textbackground(0); }
   }

// output code
// goes here

// loop until user exits function by selecting escape to go back to editing or
// by hitting enter and jumping to the selected address
_setcursortype(_NOCURSOR);
for(;;)
	{
   KeyboardInput = getkey();      // gets keyboard input on keypress
   switch(KeyboardInput)
   	{
      case 0x148:	// up
                 if(CurrentHighlighted == 0) // if it's already at the highest one
                 		break;
					  else if(CurrentHighlighted == LowestDisplayed) // if it's at the highest one currently onscreen
                     {														 // but not the highest one in the array
                 		CurrentHighlighted--;
                     LowestDisplayed--;
							HighestDisplayed--;

                     window(2,4,78,49);
							   textcolor(15);

							   for(DrawCounter = 0; DrawCounter < NumResults; DrawCounter++)
						   	{
                           textbackground(0);
							      if( ( DrawCounter < LowestDisplayed ) || ( DrawCounter > HighestDisplayed ) )
							      	;
									else { if( DrawCounter == CurrentHighlighted )
                                  	textbackground(1);
            							 cprintf("%04i %08lX ",DrawCounter + 1, Results[DrawCounter]->Address);
                           		 cprintf("%62s", Results[DrawCounter]->Data);
                                  textbackground(0); }
						      }
							}
                 else   // if it somewhere in the middle
                 		{
                     CurrentHighlighted--;
							window(2,4,78,49);
							   textcolor(15);
							   for(DrawCounter = 0; DrawCounter < NumResults; DrawCounter++)
						   	{
                           textbackground(0);
							      if( ( DrawCounter < LowestDisplayed ) || ( DrawCounter > HighestDisplayed ) )
							      	;
									else { if( DrawCounter == CurrentHighlighted )
                                  	textbackground(1);
            							 cprintf("%04i %08lX ",DrawCounter + 1, Results[DrawCounter]->Address);
                           		 cprintf("%62s", Results[DrawCounter]->Data);
                                  textbackground(0); }
						      }
                     }
      			  break;
      case 0x150: // down
                 if(CurrentHighlighted == NumResults - 1)
      				   break;
      			  else if(CurrentHighlighted == HighestDisplayed)
                 		{
                     CurrentHighlighted++;
                     LowestDisplayed++;
                     HighestDisplayed++;
                     window(2,4,78,49);
							   textcolor(15);

							   for(DrawCounter = 0; DrawCounter < NumResults; DrawCounter++)
						   	{
									textbackground(0);
							      if( ( DrawCounter < LowestDisplayed ) || ( DrawCounter > HighestDisplayed ) )
							      	;
									else { if( DrawCounter == CurrentHighlighted )
                                  	textbackground(1);
            							 cprintf("%04i %08lX ",DrawCounter + 1, Results[DrawCounter]->Address);
                           		 cprintf("%62s", Results[DrawCounter]->Data);
                                  textbackground(0); }
						      }
                     }
                 else
                 		{
                     CurrentHighlighted++;
							window(2,4,78,49);
							   textcolor(15);
							   for(DrawCounter = 0; DrawCounter < NumResults; DrawCounter++)
						   	{
                           textbackground(0);
							      if( ( DrawCounter < LowestDisplayed ) || ( DrawCounter > HighestDisplayed ) )
							      	;
									else { if( DrawCounter == CurrentHighlighted )
                                  	textbackground(1);
            							 cprintf("%04i %08lX ",DrawCounter + 1, Results[DrawCounter]->Address);
                           		 cprintf("%62s" ,Results[DrawCounter]->Data);
                                  textbackground(0); }
						      }
                     }
                 break;
      case 0x0d: // enter
					  ReturnAddress = Results[CurrentHighlighted]->Address;
                 for(DeletingThings = 0; DeletingThings < NumResults; DeletingThings++)
                 	{
                  delete(Results[DeletingThings]->Data);
						delete(Results[DeletingThings]);
                  }
                 NumResults = 0;
					  return ReturnAddress;
      case 0x1b: // escape
      			  for(DeletingThings = 0; DeletingThings < NumResults; DeletingThings++)
                 	{
                  delete(Results[DeletingThings]->Data);
						delete(Results[DeletingThings]);
                  }
                 NumResults = 0;
                 return 0;
      case 0x20: window(2,4,78,49);
      			  clrscr();
                 cprintf("Please enter the file name for the search dump\r\n");
                 cin.getline(DumpName, 25, '\n');
                 DumpFile = fopen(DumpName, "w");
                 for(DumpCounter = 0; DumpCounter < NumResults; DumpCounter++)
                 		fprintf(DumpFile, "%04i %08lX %62s", DumpCounter + 1, Results[DumpCounter]->Address, Results[DumpCounter]->Data);
      			  for(DeletingThings = 0; DeletingThings < NumResults; DeletingThings++)
                 	{
                  delete(Results[DeletingThings]->Data);
						delete(Results[DeletingThings]);
                  }
                 NumResults = 0;
                 return 0;
      default:break;
      }
   }

// pasted output
// code ends here
return 0;
}

unsigned long Searches(FILE* romfile, unsigned long int MAX_ADDRESS)
	{
   char Choice;

	window(2,4,78,49);
   clrscr();
   _setcursortype(_NORMALCURSOR);
   cprintf("What kind of search would you like to do?\r\n\n");
   cprintf("A. Relative Search\r\nB. Hex Value Search\r\n");
	Choice = getkey();
	Choice = toupper(Choice);
   while(Choice != 'A' && Choice != 'B')
   	{
      window(2,4,78,49);
   	clrscr();
   	cprintf("What kind of search would you like to do?\r\n\n");
   	cprintf("A. Relative Search\r\nB. Hex Value Search\r\n");
		Choice = getkey();
		Choice = toupper(Choice);
      }
   if(Choice == 'A')
 	   return RelativeSearch(romfile, MAX_ADDRESS);
   else 
      return HexValueSearch(romfile, MAX_ADDRESS);
   }

void script_insert(FILE *romfile, int count, table_data char_info)
	{

	FILE *script;

	unsigned long int start_address;

	BYTE_TYPE hex_value;

	char hex_data[2];
	char script_name[13];
	char start_string[9];
	char **ptr;

   int z = 0;
	int b = 0;
	int last_char_DTE = NO;
	int found = NO;

	window(2,47,78,49);
		clrscr();
		_setcursortype(_NORMALCURSOR);
		cprintf("Name of script file\r\n=> ");
		cin >> script_name; cin.ignore(1, '\n');
		clrscr();
		cprintf("Starting address of script.(hex)\r\n=> ");
		gets(start_string);
		start_address = strtoul(start_string, ptr, 16);

	script = fopen(script_name, "rb");
	fseek(script, 0, SEEK_END);

	//dynamic memory allocated for entire script
	int x = ftell(script);

	BYTE_TYPE *script_data = new BYTE_TYPE[x];
	BYTE_TYPE hex_high;
	BYTE_TYPE hex_low;
	BYTE_TYPE hex_input;

	fseek(script, 0, SEEK_SET);
	fread(script_data, sizeof(BYTE_TYPE), x, script);
	fclose(script);
	fseek(romfile, start_address, SEEK_SET);

	// write the script into the rom
	for(int q = 0; q < x; q++)
		{
		b = 0;
		last_char_DTE = NO;
		found = NO;
		while(b < count)
			{
			//converts one endline into the correct endline character for the
			//rom and two endlines into the correct endstring character
			if((script_data[q] == 0x0d) &&
			   (script_data[q + 1] == 0x0a))
				{
				q++;
				if(script_data[q + 1] == 0x0d &&
				   script_data[q + 2] == 0x0a)
					{
					q += 2;
					script_data[q] = '/';
					}
				else script_data[q] = '*';
				}

			//allows hex input from the text file
			if(script_data[q] == '~')
				{
				q++;
				strcpychar(hex_data, script_data[q]);
				q++;
				strcatchar(hex_data, script_data[q]);
				if(hex_data[0] >= 'a' && hex_data[0] <= 'f')
					{ hex_high = hex_upper(hex_data[0], 0x57); }
					else if(hex_data[0] >= '0' && hex_data[0] <= '9')
						{ hex_high = hex_upper(hex_data[0], 0x30); }
						else if(hex_data[0] >= 'A' && hex_data[0] <= 'F')
							{ hex_high = hex_upper(hex_data[0], 0x37); }
				if(hex_data[1] >= 'a' && hex_data[1] <= 'f')
					{ hex_low = hex_lower(hex_data[1], 0x57); }
					else if(hex_data[1] >= '0' && hex_data[1] <= '9')
						{ hex_low = hex_lower(hex_data[1], 0x30); }
						else if(hex_data[1] >= 'A' && hex_data[1] <= 'F')
							{ hex_low = hex_lower(hex_data[1], 0x37); }
				hex_input = hex_high + hex_low;
				fwrite(&hex_input,sizeof(BYTE_TYPE),1,romfile);
				q++;
				}

			//special routine
			else if(strlen(char_info.characters[b]) > 2)
				{
				for(z = 0;z < strlen(char_info.characters[b]);z++)
					{
					if(script_data[q + z] != char_info.characters[b][z])
						break;
					}
					if(z == strlen(char_info.characters[b]))
						{
						fwrite(&char_info.value[b],
							   sizeof(BYTE_TYPE),
							   1, romfile);
						q += strlen(char_info.characters[b]) - 1;
						found = YES;
						}
				}


			//character input
			else if((script_data[q] == char_info.characters[b][0]) &&
			   (script_data[q + 1] == char_info.characters[b][1]) &&
			   (found == NO))
			   {
			   fwrite(&char_info.value[b],
					  sizeof(BYTE_TYPE),
					  1, romfile);
			   last_char_DTE = YES;
			   found = YES;
			   }
			else if(script_data[q] == char_info.characters[b][0] &&
				(strlen(char_info.characters[b]) == 1) &&
				(found == NO))
					{
					fwrite(&char_info.value[b],
						   sizeof(BYTE_TYPE),
						   1, romfile);
						   found = YES;
					}
			b++;
			}
		if(last_char_DTE)
		   q++;
		}
	}

int main(int argc, char *argv[])
	{

        textmode(C4350);

	unsigned long int MAX_ADDRESS;
	unsigned long int edit_address;
        unsigned long int JumpToSearchResult = 0;
	unsigned long int address            = 0;

	char QuitYorN;
	char tablechoice;
	char buff;
	char size;
	char hexchoice;
	char textchoice;
        char address_input[15];
	char tablefile_name[200];
	char romname[200];
	char hex_input_string[100];
        char saveChanges[10];
        char *endptr;
	char *address_pointer  = address_input;
	char *tablename        = tablefile_name;


   int z 					 = 0;
   int TempCounter		 = 0;
	int last_char_DTE     = NO;
	int table_on          = NO;
	int found             = NO;
	int data_type;
	int Mbit              = 0;
	int xpos              = 1;
	int ypos              = 1;
	int decision;
	int count             = 0;
	int b                 = 0;
	int hex_input_counter = 0;
   int qwerty            = 0;
   int uio 					 = 0;

	long fend;

	BYTE_TYPE hex_high;
	BYTE_TYPE hex_low;
	BYTE_TYPE hex_input;
	BYTE_TYPE input_string[100];
	BYTE_TYPE *input_point = input_string;

	byte_struct area;
	table_data char_info;

        FILE *DumpChanges;
	FILE *romfile;
	fstream tablefile;

	clrscr();
	line();
	line_up(15);
	textcolor(9);
	cprintf("                           - Hexecute - by MDW2 -                           ");
	line_up(9);
	cprintf("\r\n");
	line();
	if(argc == 3)
		{
		strcpy(romname, argv[1]);
		strcpy(tablename, argv[2]);
      tablefile.open(tablename, ios::in);
      ReadTable(char_info, count, tablefile);
		tablechoice = 'Y';// a table file is being used
		table_on = YES;
		}
	if(argc == 2)
		{
		clrscr();
		strcpy(romname,argv[1]);
		int alrightythen = strlen(romname);
		for(int h = 0; h < alrightythen; h++)
			{
			romname[h] = tolower(romname[h]);
			}
		if(!strcmp("help", romname))
			{
			help_data();
			}
		cout << endl << "Will you use a hexecute table file? \n=> ";
		cin >> tablechoice;
		tablechoice = toupper(tablechoice);
		cin.ignore(20, '\n');
		while(tablechoice != 'N' && tablechoice != 'Y')
			{
			cout << endl << "Please enter a Y or an N. \n=> ";
			cin >> tablechoice;
			cin.ignore(20, '\n');
			tablechoice = toupper(tablechoice);
			}
		if(tablechoice == 'Y') // a table file is being used, else tablechoice == 'N'
			{
			cout << "Table File Name: ";
			cin >> tablename;
			cin.ignore(20, '\n');
			tablefile.open(tablename, ios::in);
         ReadTable(char_info, count, tablefile);
			}
		}
	if(argc == 1)
		{
		textcolor(15);
		cprintf("Rom File Name: ");
		cin >> romname;
		cin.ignore(20, '\n');
		cout << endl << "Will you use a hexecute table file? \n=> ";
		cin >> tablechoice;
		cin.ignore(20, '\n');
		tablechoice =  toupper(tablechoice);
		while(tablechoice != 'N' && tablechoice != 'Y')
			{
			cout << endl << "Please enter a Y or an N. \n=> ";
			cin >> tablechoice;
			cin.ignore(20, '\n');
			tablechoice = toupper(tablechoice);
			}
		if(tablechoice == 'Y')
			{
			cout << "Table File Name: ";
			cin >> tablename;
			cin.ignore(20, '\n');
			tablefile.open(tablename, ios::in);
			ReadTable(char_info, count, tablefile);
			}
		}
   romfile=fopen(romname, "r+b");
	if(!romfile) {
	  perror("Bad Mojo Error - Rom File not found");
	  return 1;	}
	fseek(romfile,0,SEEK_END);
	MAX_ADDRESS = ftell(romfile) - 0x2a0;
	newscreen();
	textcolor(15);
	edit_address = address;
	screen_refresh(area, address, romfile,xpos,ypos, table_on, count, char_info);
	for(;;)
		{
		decision = getkey();
		switch(decision) //determines action by what the keypress was
			{
			case 0x148:if(edit_address >= 0x10)
			/* up   */ {
					   if(ypos > 1)
						  {
						  ypos--;
						  edit_address -= 0x10;
						  screen_refresh(area, address, romfile, xpos, ypos, table_on, count, char_info);
						  }
					   else
						  {
						  address -= 0x10;
						  edit_address -= 0x10;
						  screen_refresh(area, address, romfile, xpos, ypos, table_on, count, char_info);
						  }
					   }
					   break;
			case 0x150:if((edit_address + 0x10) < (MAX_ADDRESS + 0x2a0))
			/* down */ {
					   if(ypos < 0x2a)
						  {
						  ypos++;
						  edit_address += 0x10;
						  screen_refresh(area, address, romfile, xpos, ypos, table_on, count, char_info);
						  }
					   else
						  {
						  address += 0x10;
						  edit_address += 0x10;
						  screen_refresh(area, address, romfile, xpos, ypos, table_on, count, char_info);
						  }
					   }
					   break;
			case 0x14b:if(edit_address != 0x00)
			/* left  */{
					   if(xpos > 1)
						  {
						  xpos--;
						  edit_address -= 0x01;
						  screen_refresh(area, address, romfile, xpos, ypos, table_on, count, char_info);
						  }
					   else if(ypos == 1)
						  {
						  address -= 0x01;
						  edit_address -= 0x01;
						  screen_refresh(area, address, romfile, xpos, ypos, table_on, count, char_info);
						  }
					   else
						  {
						  xpos = 16;
						  ypos -= 1;
						  edit_address -= 0x01;
						  screen_refresh(area, address, romfile, xpos, ypos, table_on, count, char_info);
						  }
					   }
					   break;
			case 0x14d:if(edit_address < ( MAX_ADDRESS + 0x29f ) )
			/* right */{
					   if(xpos < 16)
						  {
						  xpos++;
						  edit_address += 0x01;
						  screen_refresh(area, address, romfile, xpos, ypos, table_on, count, char_info);
						  }
					   else if(ypos == 0x2a)
						  {
						  address += 0x01;
						  edit_address += 0x01;
						  screen_refresh(area, address, romfile, xpos, ypos, table_on, count, char_info);
						  }
					   else
						 {
						 xpos = 1;
						 ypos += 1;
						 edit_address += 0x01;
						 screen_refresh(area, address, romfile, xpos, ypos, table_on, count, char_info);
						 }
					   }
					   break;
			case 0x13b:window(2,47,78,49);
			/*  F1  */ clrscr();
					  //makes cursor appear
					  _setcursortype(_NORMALCURSOR);
					  cprintf("What number type:\r\n1. decimal \r\n2. Hexadecimal\r\n-> ");
					  data_type = getkey();
					  while(data_type != 0x31 && data_type != 0x32)
							   data_type = getkey();
					  if(data_type == 0x31)
						 {
						 clrscr();
						 cprintf("Please enter the next address.\r\n-> ");
						 cin >> address;
						 cin.ignore(1, '\n');
						 clrscr();
						 }
					  if(data_type == 0x32)
						 {
						 clrscr();
						 cprintf("Please enter the next address.\r\n-> ");
						 gets(address_input);
						 address_pointer = address_input;
						 address = strtoul(address_pointer, &endptr, 16);
                   while(address > MAX_ADDRESS + 0x2a0)
                   	{
                     clrscr();
						   cprintf("Please enter the next address.\r\n-> ");
						   gets(address_input);
						   address_pointer = address_input;
						   address = strtoul(address_pointer, &endptr, 16);
                     }
						 }
                 if(address > MAX_ADDRESS)
                 	{
                  edit_address = address;
                  address = MAX_ADDRESS;
                  xpos = ( ( edit_address - address ) % 16 ) + 1;
                  ypos = ( ( edit_address - address ) / 16 ) + 1;
                  }
                 else {
					  xpos = 1; ypos = 1;
                 edit_address = address; }
					  screen_refresh(area, address, romfile,xpos,ypos, table_on, count, char_info);
					  break;
			case 0x13c:window(2,47,78,49);
			/* F2   */ clrscr();
					  //makes cursor appear
					  _setcursortype(_NORMALCURSOR);
					  cprintf("Enter the text you would like inserted.\r\n=> ");
					  gets(input_point);
					  cprintf("\r\nIs this the correct data? (y/n)");
					  textchoice = getkey();
					  if(toupper(textchoice) == 'Y')
						{

						/* works perfectly */
						if(table_on == NO)
							{
                     // declare memory for changed data
                     Changes[NumChanges] = new ChangeStruct;
                     Changes[NumChanges]->Data = new char[strlen(input_point)];

                     // write changed values into the change buffer
                     Changes[NumChanges]->Address = edit_address;
                     strcpy(Changes[NumChanges]->Data, input_point);

                     if(strlen(Changes[NumChanges]->Data) > LongestChange)
                     	LongestChange = strlen(Changes[NumChanges]->Data);

							clrscr();
							}

						/* works almost perfectly */
						if(table_on == YES)
							{
                     TempCounter = 0;

                     Changes[NumChanges] = new ChangeStruct;
                     Changes[NumChanges]->Data = new char[strlen(input_point)];

							for(int l = 0; l < strlen(input_point); l++)
								{
								b = 0;
								last_char_DTE = NO;
								found = NO;
								while(b < count)
									{
									if(strlen(char_info.characters[b]) > 2)
										{
										for(z = 0;z < strlen(char_info.characters[b]);z++)
											{
											if(input_point[l + z] != char_info.characters[b][z])
											   break;
											}
										if(z == strlen(char_info.characters[b]))
											{
                                 if(l == 0)
                                 	strcpychar(Changes[NumChanges]->Data, char_info.value[b]);
											else
                                 	strcatchar(Changes[NumChanges]->Data, char_info.value[b]);
                     				}
										}
									else if((input_point[l] == char_info.characters[b][0]) &&
									   (input_point[l+1] == char_info.characters[b][1]) &&
									   (found == NO))
										{
                              if(l == 0)
                              	strcpychar(Changes[NumChanges]->Data, char_info.value[b]);
                              else
                              	strcatchar(Changes[NumChanges]->Data, char_info.value[b]);
                     			last_char_DTE = YES;
										found = YES;
										}
									else if((input_point[l] == char_info.characters[b][0]) &&
											(strlen(char_info.characters[b]) == 1) &&
											(found == NO))
										 {
                               if(l == 0)
                               	strcpychar(Changes[NumChanges]->Data, char_info.value[b]);
                               else
                               	strcatchar(Changes[NumChanges]->Data, char_info.value[b]);
                     			 found = YES;
                               }
									b++;
									}
								if(last_char_DTE)
									l++;
                        TempCounter++;
								}
							}
                  if(TempCounter > LongestChange)
                  	LongestChange = TempCounter;
						NumChanges++;
						}
					  else
						clrscr();
					  fseek(romfile, address, SEEK_SET);
					  screen_refresh(area, address, romfile,xpos,ypos, table_on, count, char_info);
					  break;
			case 0x13d:window(2,47,78,49);
			/* F3 */   clrscr();
					  // makes cursor appear
					  _setcursortype(_NORMALCURSOR);
					  cprintf("Enter the hex value you would like inserted.\r\n=> ");
					  gets(hex_input_string);
					  cprintf("\r\nIs this the correct data? (y/n)");
					  hexchoice = getkey();
					  if(toupper(hexchoice) == 'Y')
						{
                  Changes[NumChanges] = new ChangeStruct;
                  Changes[NumChanges]->Data = new unsigned char[strlen(hex_input_string)];
                  Changes[NumChanges]->Address = edit_address;
						fseek(romfile,edit_address,SEEK_SET);
						hex_input_counter = 0;

						//********  Hex input routine **************
						while(hex_input_counter < strlen(hex_input_string))
							{
							if(hex_input_string[hex_input_counter] >= 'a' &&
							   hex_input_string[hex_input_counter] <= 'f')
								{ hex_high = hex_upper(hex_input_string[hex_input_counter], 0x57); }
							else if(hex_input_string[hex_input_counter] >= '0' &&
									hex_input_string[hex_input_counter] <= '9')
									 { hex_high = hex_upper(hex_input_string[hex_input_counter], 0x30); }
								 else if(hex_input_string[hex_input_counter] >= 'A' &&
										 hex_input_string[hex_input_counter] <= 'F')
										  { hex_high = hex_upper(hex_input_string[hex_input_counter], 0x37); }
							hex_input_counter++;
							if(hex_input_string[hex_input_counter] >= 'a' &&
							   hex_input_string[hex_input_counter] <= 'f')
								{hex_low = hex_lower(hex_input_string[hex_input_counter], 0x57); }
							else if(hex_input_string[hex_input_counter] >= '0' &&
									hex_input_string[hex_input_counter] <= '9')
									 {hex_low = hex_lower(hex_input_string[hex_input_counter], 0x30); }
								 else if(hex_input_string[hex_input_counter] >= 'A' &&
										 hex_input_string[hex_input_counter] <= 'F')
										  {hex_low = hex_lower(hex_input_string[hex_input_counter], 0x37); }
							hex_input = hex_low + hex_high;
                     if(hex_input_counter == 1)
                     	strcpychar(Changes[NumChanges]->Data, hex_input);
                     else
                     	strcatchar(Changes[NumChanges]->Data, hex_input);
							hex_input_counter++;
							}
						}
					  NumChanges++;	
					  clrscr();
					  fseek(romfile, edit_address, SEEK_SET);
					  screen_refresh(area, address, romfile,xpos,ypos, table_on, count, char_info);
					  break;
			case 0x13e:Mbit = 0;
			/*  F4  */
					  //makes cursor appear
					  _setcursortype(_NORMALCURSOR);
					  screen_refresh(area, address, romfile,xpos,ypos, table_on, count, char_info);
					  fseek(romfile,0,SEEK_END);
					  fend = ftell(romfile);
					  fseek(romfile,0x20000,SEEK_SET);
					  while(ftell(romfile) < fend)
						{
						Mbit += 1;
						fseek(romfile,0x20000,SEEK_CUR);
						}
					  fclose(romfile);
					  window(2,47,78,49);
					  clrscr();
					  cprintf(" Filename: %s  Size: %dMb\r\n",romname, int(Mbit));
					  romfile=fopen(romname, "a+b");
					  _setcursortype(_NORMALCURSOR);
					  cprintf(" Expand to:  1. 8Mb  2. 16Mb  3. 24Mb  4. 32Mb\r\n");
					  cprintf(" q. don't expand the rom  => ");
					  cin >> size;
					  switch(toupper(size))
						{
						case '1':if(Mbit >= 8)
									{
									too_small(Mbit);
									}
								 else
									{
									rom_expand(8, romfile);
									fread(&area,sizeof(byte_struct),1,romfile);
									}
							   break;
						case '2':if(Mbit >= 16)
									{
									too_small(Mbit);
									}
								 else
									{
									rom_expand(16, romfile);
									fread(&area,sizeof(byte_struct),1,romfile);
									}
							   break;
						case '3':if(Mbit >= 24)
									{
									too_small(Mbit);
									}
								 else
									{
									rom_expand(24, romfile);
									fread(&area,sizeof(byte_struct),1,romfile);
									}
							   break;
						case '4':if(Mbit >= 32)
									{
									too_small(Mbit);
									}
								 else
									{
									rom_expand(32, romfile);
									fread(&area,sizeof(byte_struct),1,romfile);
									}
							   break;
						default:break;
						}
					  fclose(romfile);
					  romfile=fopen(romname, "r+b");
					  cin.ignore(1, '\n');
					  clrscr();
					  _setcursortype(_NOCURSOR);
					  screen_refresh(area, address, romfile,xpos,ypos, table_on, count, char_info);
					  break;
			case 0x1b:window(2,47,78,49);
			/* esc */ clrscr();
					  //makes cursor appear
					  _setcursortype(_NORMALCURSOR);
					  cprintf("Are you sure you want to quit?\r\n=> ");
					  QuitYorN = getkey();
					  while(QuitYorN != 'y' && QuitYorN != 'n')
						 {
						 clrscr();
						 cprintf("Please enter a Y or an N\r\n=> ");
						 QuitYorN = getkey();
						 }
					  if(toupper(QuitYorN) == 'Y')
						 {
						 if(NumChanges) {
                   clrscr();
                   cprintf("Would you like to save changes?\r\n(y/n)=> ");
                   cin >> saveChanges; cin.ignore(1, '\n');
                   if(toupper(saveChanges[0]) == 'Y')
                   	{
                     unsigned char Extension[5];
							for( uio = 0; uio < NumChanges; uio++)
                     	{
                        fseek(romfile, Changes[uio]->Address, SEEK_SET);
                        fwrite(Changes[uio]->Data, sizeof(unsigned char), strlen(Changes[uio]->Data), romfile);
                        }
                     /*
                     for(int ExtensionCounter = 0; ExtensionCounter < 3; ExtensionCounter++)
                     	{
                        Extension[ExtensionCounter] = romname[ ( strlen(romname) - 1 ) - ExtensionCounter];
                        }
                     if(!strcmpi(Extension, "bg.") || !strcmpi(Extension, "cbg") )
                     	{
                        char FixChecksum;
                        clrscr();
                        cprintf("Would you like the fix the checksum?\r\n(y/n)=> ");
                        cin >> FixChecksum; cin.ignore(10, '\n');
                        FixChecksum = toupper(FixChecksum);
                        while(FixChecksum != 'Y' && FixChecksum != 'N')
                        	{
                           clrscr();
                           cprintf("Would you like the fix the checksum?\r\n(y/n)=> ");
                           cin >> FixChecksum; cin.ignore(10, '\n');
                           FixChecksum = toupper(FixChecksum);
                           }
                        if(FixChecksum == 'Y')
                        	{
                           unsigned long Checksum;
                           unsigned long TempSum;
                           unsigned char HighByte;
                           unsigned char LowByte;
                           unsigned char TempChar;

									fseek(romfile, 0, SEEK_END);
									fread(&TempChar, 1, sizeof(unsigned char), romfile);
                           Checksum += TempChar;
									MAX_ADDRESS = ftell(romfile);
                           fseek(romfile, 0, SEEK_SET);
                           for(int ChecksumCounter = 0; ChecksumCounter < MAX_ADDRESS; ChecksumCounter++)
                           	{
                              fread(&TempChar, 1, sizeof(unsigned char), romfile);
                              Checksum += TempChar;
                              }
									Checksum &= 0x0000FFFF;
                           TempSum = Checksum >> 8;
                           HighByte = TempSum;
                           LowByte = Checksum & 0x000000FF;
                           fseek(romfile, 0x14e, SEEK_SET);
                           fwrite(&LowByte, 1, sizeof(unsigned char), romfile);
                           fwrite(&HighByte, 1, sizeof(unsigned char), romfile);
                           }
								}
                     */
                     }
                   }
                   window(1,1,80,50);
						 clrscr();
						 fclose(romfile);
						 end_data();
						 }
					  else
						 clrscr();
					  break;
			case 0x151:if((address + 0x100) > MAX_ADDRESS)
			/* pgdn */    break;
					   else address += 0x100;
					   screen_refresh(area, address, romfile,xpos,ypos, table_on, count, char_info);
					   edit_address += 0x100;
					   break;
			case 0x149:if(address <= 0x100)
			/*pgup*/      {
						  address = 0x00;
						  edit_address = address;
						  xpos = 1; ypos = 1;
						  screen_refresh(area, address, romfile,xpos,ypos, table_on, count, char_info);
						  }
					   else
						  {
						  address -= 0x100;
						  edit_address -= 0x100;
						  screen_refresh(area, address, romfile,xpos,ypos, table_on, count, char_info);
						  }
					   edit_address = address;
					   break;
			case 0x14f:fseek(romfile,MAX_ADDRESS,SEEK_END);
			/* end */  address = MAX_ADDRESS;
					   edit_address = address;
					   xpos = 1; ypos = 1;
					   screen_refresh(area, address, romfile,xpos,ypos, table_on, count, char_info);
					   break;
			case 0x147:address = 0;
			/* home */ edit_address = address;
					   xpos = 1; ypos = 1;
					   screen_refresh(area, address, romfile,xpos,ypos, table_on, count, char_info);
					   break;
			case 0x13f:script_dump(char_info, romfile, count);
			/* F5   */ screen_refresh(area, address, romfile,xpos,ypos, table_on, count, char_info);
					   break;
			case 0x09:if(tablechoice == 'Y')
			/* tab  */   {
						 if(table_on == YES)
							table_on = NO;
						 else if(table_on == NO)
							  table_on = YES;
						 window(45,4,78,19);
							clrscr();
						 screen_refresh(area, address, romfile,xpos,ypos, table_on, count, char_info);
						 }
					  break;
			case 0x140:JumpToSearchResult = Searches(romfile, MAX_ADDRESS);
                    //JumpToSearchResult = RelativeSearch(romfile, MAX_ADDRESS);
			/* F6 */   if(JumpToSearchResult)
                        {
        					   address = JumpToSearchResult;
                        if(address > MAX_ADDRESS)
                 				{
			                  edit_address = address;
				               address = MAX_ADDRESS;
            			      xpos = ( ( edit_address - address ) % 16 ) + 1;
			                  ypos = ( ( edit_address - address ) / 16 ) + 1;
        				         }
                        else {
                        	xpos = 1; ypos = 1;
                        	edit_address = address;
                           }
                        JumpToSearchResult = 0;
                        }
         			  newscreen();
  					     screen_refresh(area, address, romfile,xpos,ypos, table_on, count, char_info);
   				     break;
			case 0x141:// F7
                    GraphicsRoutines();
                    newscreen();
					     screen_refresh(area, address, romfile,xpos,ypos, table_on, count, char_info);
					     break;
			case 0x142:script_insert(romfile, count, char_info);
			/* F8  */  newscreen();
					     screen_refresh(area, address, romfile,xpos,ypos, table_on, count, char_info);
			default:break;
			}
		}
	}
